/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.healingcampfire.events;

import com.natamus.healingcampfire.config.ConfigHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CampfireEvent {
    private static int tickcount = 0;
    private static Map<BlockPos, Dimension> cfworld = new HashMap<BlockPos, Dimension>();
    private static List<BlockPos> campfires = new ArrayList<BlockPos>();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K) {
            return;
        }
        if (tickcount > 0) {
            --tickcount;
            return;
        }
        tickcount = 20;
        EffectInstance effectinstance = (Boolean)ConfigHandler.GENERAL.hideEffectParticles.get() != false ? new EffectInstance(Effects.field_76428_l.getEffect(), (Integer)ConfigHandler.GENERAL.effectDurationSeconds.get() * 20, 0, true, false) : new EffectInstance(Effects.field_76428_l.getEffect(), (Integer)ConfigHandler.GENERAL.effectDurationSeconds.get() * 20);
        ArrayList<BlockPos> toremove = new ArrayList<BlockPos>();
        Object[] forcampfires = campfires.toArray();
        for (Object o : forcampfires) {
            BlockPos campfire = (BlockPos)o;
            if (!cfworld.containsKey(campfire)) {
                toremove.add(campfire);
                continue;
            }
            if (!cfworld.get(campfire).equals(world.func_201675_m())) continue;
            ChunkPos chunkpos = world.func_175726_f(campfire).func_76632_l();
            if (!world.func_72863_F().func_73149_a(chunkpos.field_77276_a, chunkpos.field_77275_b)) {
                toremove.add(campfire);
                continue;
            }
            if (!world.func_180495_p(campfire).func_177230_c().equals(Blocks.field_222433_lV)) {
                toremove.add(campfire);
                continue;
            }
            double r = ((Integer)ConfigHandler.GENERAL.healingRadius.get()).intValue();
            if (!((Boolean)ConfigHandler.GENERAL.healPassiveMobs.get()).booleanValue()) continue;
            for (Entity entity : world.func_72839_b(null, new AxisAlignedBB((double)campfire.func_177958_n() - r, (double)campfire.func_177956_o() - r, (double)campfire.func_177952_p() - r, (double)campfire.func_177958_n() + r, (double)campfire.func_177956_o() + r, (double)campfire.func_177952_p() + r))) {
                if (entity instanceof PlayerEntity) {
                    ((PlayerEntity)entity).func_195064_c(effectinstance);
                    continue;
                }
                if (!(entity instanceof LivingEntity) || entity.func_200600_R().func_220339_d().equals((Object)EntityClassification.MONSTER)) continue;
                ((LivingEntity)entity).func_195064_c(effectinstance);
            }
        }
        if (toremove.size() > 0) {
            for (BlockPos tr : toremove) {
                campfires.remove(tr);
                cfworld.remove(tr);
            }
        }
    }

    @SubscribeEvent
    public void onChuckLoad(ChunkWatchEvent.Watch e) {
        World pworld = e.getPlayer().func_130014_f_();
        if (pworld.field_72995_K) {
            return;
        }
        ChunkPos pos = e.getPos();
        Chunk chunk = pworld.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
        int a = chunk.func_76632_l().field_77276_a * 16;
        int b = chunk.func_76632_l().field_77275_b * 16;
        for (double x = 0.0; x <= 15.0; x += 1.0) {
            for (double y = 0.0; y <= 256.0; y += 1.0) {
                for (double z = 0.0; z <= 15.0; z += 1.0) {
                    BlockPos actualPosition = new BlockPos((double)a + x, y, (double)b + z).func_185334_h();
                    BlockState state = chunk.func_180495_p(actualPosition);
                    Block block = state.func_177230_c();
                    if (!block.equals(Blocks.field_222433_lV)) continue;
                    campfires.add(actualPosition.func_185334_h());
                    cfworld.put(actualPosition.func_185334_h(), pworld.func_201675_m());
                }
            }
        }
    }

    @SubscribeEvent
    public void onClick(final PlayerInteractEvent.RightClickBlock e) {
        final World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        ItemStack itemstack = e.getItemStack();
        if (itemstack.func_77973_b().equals(Items.field_222113_pS)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    BlockPos clickpos = e.getPos();
                    Iterator it = BlockPos.func_218287_a((int)(clickpos.func_177958_n() - 1), (int)(clickpos.func_177956_o() - 1), (int)(clickpos.func_177952_p() - 1), (int)(clickpos.func_177958_n() + 1), (int)(clickpos.func_177956_o() + 1), (int)(clickpos.func_177952_p() + 1)).iterator();
                    while (it.hasNext()) {
                        BlockPos np = (BlockPos)it.next();
                        if (!world.func_180495_p(np).func_177230_c().equals(Blocks.field_222433_lV)) continue;
                        campfires.add(np.func_185334_h());
                        cfworld.put(np.func_185334_h(), world.func_201675_m());
                        break;
                    }
                }
            }).start();
        }
    }
}

