/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.client.RendererBossGlow;
import atomicstryker.infernalmobs.common.ISidedProxy;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class InfernalMobsClient
implements ISidedProxy {
    private static int airOverrideValue = -999;
    private final double NAME_VISION_DISTANCE = 32.0;
    private Minecraft mc;
    private World lastWorld;
    private long nextPacketTime;
    private ConcurrentHashMap<EntityLivingBase, MobModifier> rareMobsClient;
    private long healthBarRetainTime;
    private EntityLivingBase retainedTarget;

    public static void onHealthPacketForClient(HealthPacket healthPacket) {
        MobModifier mod;
        Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(healthPacket.getEntID());
        if (ent instanceof EntityLivingBase && (mod = InfernalMobsCore.getMobModifiers((EntityLivingBase)ent)) != null) {
            mod.setActualHealth(healthPacket.getHealth(), healthPacket.getMaxhealth());
        }
    }

    public static void overrideAir(int air) {
        airOverrideValue = air;
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.mc = Minecraft.func_71410_x();
    }

    @Override
    public void load() {
        this.nextPacketTime = 0L;
        this.rareMobsClient = new ConcurrentHashMap();
        MinecraftForge.EVENT_BUS.register((Object)new RendererBossGlow());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.healthBarRetainTime = 0L;
        this.retainedTarget = null;
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && this.mc.field_71439_g != null && (event.getEntity() instanceof EntityMob || event.getEntity() instanceof EntityLivingBase && event.getEntity() instanceof IMob)) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(this.mc.field_71439_g.func_200200_C_().func_150261_e(), event.getEntity().func_145782_y(), 0));
        }
    }

    private void askServerHealth(Entity ent) {
        if (System.currentTimeMillis() > this.nextPacketTime) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new HealthPacket(this.mc.field_71439_g.func_200200_C_().func_150261_e(), ent.func_145782_y(), 0.0f, 0.0f));
            this.nextPacketTime = System.currentTimeMillis() + 100L;
        }
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        MobModifier mod;
        if (InfernalMobsCore.instance().getIsHealthBarDisabled() || event.getType() != RenderGameOverlayEvent.ElementType.BOSSHEALTH || this.mc.field_71456_v.func_184046_j().func_184054_d()) {
            return;
        }
        Entity ent = this.getEntityCrosshairOver(event.getPartialTicks(), this.mc);
        boolean retained = false;
        if (ent == null && System.currentTimeMillis() < this.healthBarRetainTime) {
            ent = this.retainedTarget;
            retained = true;
        }
        if (ent != null && ent instanceof EntityLivingBase && (mod = InfernalMobsCore.getMobModifiers((EntityLivingBase)ent)) != null) {
            this.askServerHealth(ent);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            GL11.glDisable((int)3042);
            EntityLivingBase target = (EntityLivingBase)ent;
            String buffer = mod.getEntityDisplayName(target);
            int screenwidth = this.mc.field_195558_d.func_198107_o();
            FontRenderer fontR = this.mc.field_71466_p;
            GuiIngame gui = this.mc.field_71456_v;
            int lifeBarLength = 182;
            int x = screenwidth / 2 - lifeBarLength / 2;
            int lifeBarLeft = (int)(mod.getActualHealth(target) / mod.getActualMaxHealth(target) * (float)(lifeBarLength + 1));
            int y = 12;
            gui.func_73729_b(x, y, 0, 74, lifeBarLength, 5);
            gui.func_73729_b(x, y, 0, 74, lifeBarLength, 5);
            if (lifeBarLeft > 0) {
                gui.func_73729_b(x, y, 0, 79, lifeBarLeft, 5);
            }
            int yCoord = 10;
            fontR.func_175063_a(buffer, (float)(screenwidth / 2 - fontR.func_78256_a(buffer) / 2), (float)yCoord, 3118827);
            String[] display = mod.getDisplayNames();
            for (int i = 0; i < display.length && display[i] != null; ++i) {
                fontR.func_175063_a(display[i], (float)(screenwidth / 2 - fontR.func_78256_a(display[i]) / 2), (float)(yCoord += 10), 0xFFFFFF);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            if (!retained) {
                this.retainedTarget = target;
                this.healthBarRetainTime = System.currentTimeMillis() + 3000L;
            }
        }
    }

    private Entity getEntityCrosshairOver(float partialTicks, Minecraft mc) {
        Entity returnedEntity = null;
        Entity viewEntity = mc.func_175606_aa();
        if (mc.field_71441_e != null && viewEntity != null) {
            double distance = 32.0;
            RayTraceResult traceResult = viewEntity.func_174822_a(distance, partialTicks, RayTraceFluidMode.NEVER);
            Vec3d viewEntEyeVec = viewEntity.func_174824_e(partialTicks);
            if (traceResult != null) {
                distance = traceResult.field_72307_f.func_72438_d(viewEntEyeVec);
            }
            Vec3d lookVector = viewEntity.func_70676_i(1.0f);
            Vec3d viewEntEyeRay = viewEntEyeVec.func_72441_c(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance);
            Vec3d intersectVector = null;
            List list = this.mc.field_71441_e.func_175674_a(viewEntity, viewEntity.func_174813_aQ().func_72321_a(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance).func_72314_b(1.0, 1.0, 1.0), EntitySelectors.field_180132_d.and(Entity::func_70067_L));
            for (Entity candidateHit : list) {
                double d3;
                AxisAlignedBB axisalignedbb = candidateHit.func_174813_aQ().func_186662_g((double)candidateHit.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(viewEntEyeVec, viewEntEyeRay);
                if (axisalignedbb.func_72318_a(viewEntEyeVec)) {
                    if (!(distance >= 0.0)) continue;
                    returnedEntity = candidateHit;
                    intersectVector = raytraceresult == null ? viewEntEyeVec : raytraceresult.field_72307_f;
                    distance = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = viewEntEyeVec.func_72438_d(raytraceresult.field_72307_f)) < distance) && distance != 0.0) continue;
                if (candidateHit.func_184208_bv() == viewEntity.func_184208_bv() && !candidateHit.canRiderInteract()) {
                    if (distance != 0.0) continue;
                    returnedEntity = candidateHit;
                    intersectVector = raytraceresult.field_72307_f;
                    continue;
                }
                returnedEntity = candidateHit;
                intersectVector = raytraceresult.field_72307_f;
                distance = d3;
            }
            if (returnedEntity != null && viewEntEyeVec.func_72438_d(intersectVector) > 32.0) {
                returnedEntity = null;
            }
        }
        return returnedEntity;
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent tick) {
        if (this.mc.field_71441_e == null || this.mc.field_71462_r != null && this.mc.field_71462_r.func_73868_f()) {
            return;
        }
        if (this.mc.field_71441_e != this.lastWorld) {
            boolean newGame = this.lastWorld == null;
            this.lastWorld = this.mc.field_71441_e;
            if (!newGame) {
                InfernalMobsCore.proxy.getRareMobs().clear();
            }
        }
    }

    @Override
    public ConcurrentHashMap<EntityLivingBase, MobModifier> getRareMobs() {
        return this.rareMobsClient;
    }

    @Override
    public void onHealthPacketForClient(int entID, float health, float maxhealth) {
    }

    @Override
    public void onKnockBackPacket(float xv, float zv) {
        MM_Gravity.knockBack((EntityLivingBase)this.mc.field_71439_g, xv, zv);
    }

    @Override
    public void onMobModsPacketToClient(String stringData, int entID) {
        InfernalMobsCore.instance().addRemoteEntityModifiers((World)this.mc.field_71441_e, entID, stringData);
    }

    @Override
    public void onVelocityPacket(float xv, float yv, float zv) {
        this.mc.field_71439_g.func_70024_g((double)xv, (double)yv, (double)zv);
    }

    @Override
    public void onAirPacket(int air) {
        airOverrideValue = air;
    }

    @SubscribeEvent
    public void onTick(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && !this.mc.field_71439_g.func_208600_a(FluidTags.field_206959_a) && airOverrideValue != -999) {
            GL11.glEnable((int)3042);
            int right_height = 39;
            int left = this.mc.field_195558_d.func_198107_o() / 2 + 91;
            int top = this.mc.field_195558_d.func_198087_p() - right_height;
            int full = MathHelper.func_76143_f((double)((double)(airOverrideValue - 2) * 10.0 / 300.0));
            int partial = MathHelper.func_76143_f((double)((double)airOverrideValue * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                this.mc.field_71456_v.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
            }
            GL11.glDisable((int)3042);
        }
    }
}

