/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.GsonConfig;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityEventHandler {
    private final HashMap<Tuple<Integer, Integer>, Float> damageMap = new HashMap();
    private long nextMapEvaluation = System.currentTimeMillis();

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            String savedMods = event.getEntity().getEntityData().func_74779_i(InfernalMobsCore.instance().getNBTTag());
            if (!savedMods.equals("")) {
                InfernalMobsCore.instance().addEntityModifiersByString((EntityLivingBase)event.getEntity(), savedMods);
            } else {
                InfernalMobsCore.instance().processEntitySpawn((EntityLivingBase)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        MobModifier mod;
        if (!event.getEntity().field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null && mod.onDeath()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        MobModifier mod;
        if (!event.getEntity().field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
            mod.onSetAttackTarget(event.getTarget());
        }
    }

    @SubscribeEvent
    public void onEntityLivingAttacked(LivingAttackEvent event) {
    }

    @SubscribeEvent
    public void onEntityLivingHurt(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() != event.getEntityLiving()) {
            Entity attacker;
            MobModifier mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving());
            if (mod != null) {
                event.setAmount(mod.onHurt(event.getEntityLiving(), event.getSource(), event.getAmount()));
            }
            if ((attacker = event.getSource().func_76346_g()) instanceof EntityLivingBase && (mod = InfernalMobsCore.getMobModifiers((EntityLivingBase)attacker)) != null) {
                event.setAmount(mod.onAttack(event.getEntityLiving(), event.getSource(), event.getAmount()));
            }
            if (InfernalMobsCore.instance().config.isAntiMobFarm() && (event.getSource() == DamageSource.field_76367_g || event.getSource() == DamageSource.field_76369_e || event.getSource() == DamageSource.field_76379_h || event.getSource() == DamageSource.field_76368_d || event.getSource() == DamageSource.field_76371_c || event.getSource().func_76346_g() instanceof FakePlayer)) {
                Tuple cpair = new Tuple((Object)((int)event.getEntityLiving().field_70165_t), (Object)((int)event.getEntityLiving().field_70161_v));
                Float value = this.damageMap.get(cpair);
                if (value == null) {
                    for (Map.Entry<Tuple<Integer, Integer>, Float> e : this.damageMap.entrySet()) {
                        if (Math.abs((Integer)e.getKey().func_76341_a() - (Integer)cpair.func_76341_a()) >= 3 || Math.abs((Integer)e.getKey().func_76340_b() - (Integer)cpair.func_76340_b()) >= 3) continue;
                        e.setValue(Float.valueOf(e.getValue().floatValue() + event.getAmount()));
                        break;
                    }
                } else {
                    this.damageMap.put((Tuple<Integer, Integer>)cpair, Float.valueOf(value.floatValue() + event.getAmount()));
                    GsonConfig.saveConfig(InfernalMobsCore.instance().config, InfernalMobsCore.instance().configFile);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingFall(LivingFallEvent event) {
        MobModifier mod;
        if (!event.getEntity().field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
            event.setCanceled(mod.onFall(event.getDistance()));
        }
    }

    @SubscribeEvent
    public void onEntityLivingJump(LivingEvent.LivingJumpEvent event) {
        MobModifier mod;
        if (!event.getEntity().field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
            mod.onJump(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            MobModifier mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving());
            if (mod != null) {
                mod.onUpdate(event.getEntityLiving());
            }
            if (InfernalMobsCore.instance().config.isAntiMobFarm() && System.currentTimeMillis() > this.nextMapEvaluation) {
                if (!this.damageMap.isEmpty()) {
                    float maxDamage = 0.0f;
                    Tuple<Integer, Integer> maxC = null;
                    for (Map.Entry<Tuple<Integer, Integer>, Float> e : this.damageMap.entrySet()) {
                        float val = e.getValue().floatValue();
                        if (!(val > maxDamage)) continue;
                        maxC = e.getKey();
                        maxDamage = val;
                    }
                    if (maxC != null) {
                        System.out.println("Infernal Mobs AntiMobFarm damage check, max detected chunk damage value " + maxDamage + " near coords " + maxC.func_76341_a() + ", " + maxC.func_76340_b());
                        if (maxDamage > InfernalMobsCore.instance().config.getMobFarmDamageTrigger()) {
                            MinecraftForge.EVENT_BUS.post((Event)new MobFarmDetectedEvent(event.getEntityLiving().field_70170_p.func_72964_e(((Integer)maxC.func_76341_a()).intValue(), ((Integer)maxC.func_76340_b()).intValue()), InfernalMobsCore.instance().config.getMobFarmCheckIntervals(), maxDamage));
                        }
                    }
                    this.damageMap.clear();
                }
                this.nextMapEvaluation = System.currentTimeMillis() + InfernalMobsCore.instance().config.getMobFarmCheckIntervals();
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDrops(LivingDropsEvent event) {
        MobModifier mod;
        if (!event.getEntity().field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
            mod.onDropItems(event.getEntityLiving(), event.getSource(), event.getDrops(), event.getLootingLevel(), event.isRecentlyHit(), event.getLootingLevel());
            InfernalMobsCore.removeEntFromElites(event.getEntityLiving());
        }
    }

    public static class MobFarmDetectedEvent
    extends ChunkEvent {
        public final long triggeringInterval;
        public final float triggeringDamage;

        public MobFarmDetectedEvent(Chunk chunk, long ti, float td) {
            super((IChunk)chunk);
            this.triggeringInterval = ti;
            this.triggeringDamage = td;
        }
    }
}

