/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class HealthPacket
implements NetworkHelper.IPacket {
    private String stringData;
    private int entID;
    private float health;
    private float maxhealth;

    public HealthPacket() {
    }

    public HealthPacket(String u, int i, float entHealth, float entMaxHealth) {
        this.stringData = u;
        this.entID = i;
        this.health = entHealth;
        this.maxhealth = entMaxHealth;
    }

    @Override
    public void encode(Object msg, PacketBuffer packetBuffer) {
        HealthPacket healthPacket = (HealthPacket)msg;
        packetBuffer.func_180714_a(healthPacket.stringData);
        packetBuffer.writeInt(healthPacket.entID);
        packetBuffer.writeFloat(healthPacket.health);
        packetBuffer.writeFloat(healthPacket.maxhealth);
    }

    @Override
    public <MSG> MSG decode(PacketBuffer packetBuffer) {
        HealthPacket result = new HealthPacket();
        result.stringData = packetBuffer.func_150789_c(Short.MAX_VALUE);
        result.entID = packetBuffer.readInt();
        result.health = packetBuffer.readFloat();
        result.maxhealth = packetBuffer.readFloat();
        return (MSG)result;
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            HealthPacket healthPacket = (HealthPacket)msg;
            if (healthPacket.maxhealth > 0.0f) {
                Minecraft.func_71410_x().func_152344_a(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> InfernalMobsClient.onHealthPacketForClient(healthPacket)));
            } else {
                EntityLivingBase e;
                MobModifier mod;
                Entity ent;
                EntityPlayerMP p = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(healthPacket.stringData);
                if (p != null && (ent = p.field_70170_p.func_73045_a(healthPacket.entID)) instanceof EntityLivingBase && (mod = InfernalMobsCore.getMobModifiers(e = (EntityLivingBase)ent)) != null) {
                    this.stringData = healthPacket.stringData;
                    this.entID = healthPacket.entID;
                    this.health = e.func_110143_aJ();
                    this.maxhealth = e.func_110138_aP();
                    InfernalMobsCore.instance().networkHelper.sendPacketToPlayer(new HealthPacket(this.stringData, this.entID, this.health, this.maxhealth), p);
                }
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public String getStringData() {
        return this.stringData;
    }

    public int getEntID() {
        return this.entID;
    }

    public float getHealth() {
        return this.health;
    }

    public float getMaxhealth() {
        return this.maxhealth;
    }
}

