/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MobModsPacket
implements NetworkHelper.IPacket {
    private String stringData;
    private int entID;
    private byte sentFromServer;

    public MobModsPacket() {
    }

    public MobModsPacket(String str, int i, byte ir) {
        this.stringData = str;
        this.entID = i;
        this.sentFromServer = ir;
    }

    @Override
    public void encode(Object msg, PacketBuffer packetBuffer) {
        MobModsPacket mobModsPacket = (MobModsPacket)msg;
        packetBuffer.writeByte((int)mobModsPacket.sentFromServer);
        packetBuffer.writeShort(mobModsPacket.stringData.length());
        for (char c : mobModsPacket.stringData.toCharArray()) {
            packetBuffer.writeChar((int)c);
        }
        packetBuffer.writeInt(this.entID);
    }

    @Override
    public <MSG> MSG decode(PacketBuffer packetBuffer) {
        MobModsPacket mobModsPacket = new MobModsPacket();
        mobModsPacket.sentFromServer = packetBuffer.readByte();
        int len = packetBuffer.readShort();
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = packetBuffer.readChar();
        }
        mobModsPacket.stringData = String.valueOf(chars);
        mobModsPacket.entID = packetBuffer.readInt();
        return (MSG)mobModsPacket;
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        MobModsPacket mobModsPacket = (MobModsPacket)msg;
        if (this.sentFromServer != 0) {
            InfernalMobsCore.instance().addRemoteEntityModifiers((World)Minecraft.func_71410_x().field_71441_e, this.entID, this.stringData);
        } else {
            EntityLivingBase e;
            MobModifier mod;
            Entity ent;
            EntityPlayerMP p = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(this.stringData);
            if (p != null && (ent = p.field_70170_p.func_73045_a(this.entID)) instanceof EntityLivingBase && (mod = InfernalMobsCore.getMobModifiers(e = (EntityLivingBase)ent)) != null) {
                this.stringData = mod.getLinkedModNameUntranslated();
                InfernalMobsCore.instance().networkHelper.sendPacketToPlayer(new MobModsPacket(this.stringData, this.entID, 1), p);
                InfernalMobsCore.instance().sendHealthPacket(e);
            }
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

