/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.client.RendererBossGlow;
import atomicstryker.infernalmobs.common.ISidedProxy;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import org.lwjgl.opengl.GL11;

public class InfernalMobsClient
implements ISidedProxy {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    private static int airOverrideValue = -999;
    private final double NAME_VISION_DISTANCE = 32.0;
    private long airDisplayTimeout;
    private Minecraft mc;
    private World lastWorld;
    private long nextPacketTime;
    private final ConcurrentHashMap<LivingEntity, MobModifier> rareMobsClient = new ConcurrentHashMap();
    private long healthBarRetainTime;
    private LivingEntity retainedTarget;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.mc = Minecraft.func_71410_x();
    }

    @Override
    public void load() {
        this.nextPacketTime = 0L;
        this.rareMobsClient.clear();
        MinecraftForge.EVENT_BUS.register((Object)new RendererBossGlow());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.healthBarRetainTime = 0L;
        this.retainedTarget = null;
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && this.mc.field_71439_g != null && (event.getEntity() instanceof MobEntity || event.getEntity() instanceof LivingEntity && event.getEntity() instanceof IMob)) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(this.mc.field_71439_g.func_200200_C_().func_150261_e(), event.getEntity().func_145782_y(), 0));
            InfernalMobsCore.LOGGER.debug("onEntityJoinedWorld {}, ent-id {} querying modifiers from server", (Object)event.getEntity(), (Object)event.getEntity().func_145782_y());
        }
    }

    private void askServerMods(Entity ent) {
        if (System.currentTimeMillis() > this.nextPacketTime && (ent instanceof MobEntity || ent instanceof LivingEntity && ent instanceof IMob)) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(this.mc.field_71439_g.func_200200_C_().func_150261_e(), ent.func_145782_y(), 0));
            InfernalMobsCore.LOGGER.debug("askServerMods {}, ent-id {} querying modifiers from server", (Object)ent, (Object)ent.func_145782_y());
            this.nextPacketTime = System.currentTimeMillis() + 100L;
        }
    }

    private void askServerHealth(Entity ent) {
        if (System.currentTimeMillis() > this.nextPacketTime) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new HealthPacket(this.mc.field_71439_g.func_200200_C_().func_150261_e(), ent.func_145782_y(), 0.0f, 0.0f));
            this.nextPacketTime = System.currentTimeMillis() + 100L;
        }
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (InfernalMobsCore.instance().getIsHealthBarDisabled() || event.getType() != RenderGameOverlayEvent.ElementType.BOSSHEALTH || this.mc.field_71456_v.func_184046_j().func_184054_d()) {
            return;
        }
        LivingEntity ent = this.getEntityCrosshairOver(event.getPartialTicks(), this.mc);
        boolean retained = false;
        if (ent == null && System.currentTimeMillis() < this.healthBarRetainTime) {
            ent = this.retainedTarget;
            retained = true;
        }
        if (ent != null) {
            MobModifier mod = InfernalMobsCore.getMobModifiers(ent);
            if (mod != null) {
                this.askServerHealth((Entity)ent);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.func_110434_K().func_110577_a(GUI_BARS_TEXTURES);
                GL11.glDisable((int)3042);
                String buffer = mod.getEntityDisplayName(ent);
                int screenwidth = this.mc.func_228018_at_().func_198107_o();
                FontRenderer fontR = this.mc.field_71466_p;
                IngameGui gui = this.mc.field_71456_v;
                int lifeBarLength = 182;
                int x = screenwidth / 2 - lifeBarLength / 2;
                int lifeBarLeft = (int)(mod.getActualHealth(ent) / mod.getActualMaxHealth(ent) * (float)(lifeBarLength + 1));
                int y = 12;
                gui.blit(x, y, 0, 74, lifeBarLength, 5);
                gui.blit(x, y, 0, 74, lifeBarLength, 5);
                if (lifeBarLeft > 0) {
                    gui.blit(x, y, 0, 79, lifeBarLeft, 5);
                }
                int yCoord = 10;
                fontR.func_175063_a(buffer, (float)(screenwidth / 2 - fontR.func_78256_a(buffer) / 2), (float)yCoord, 3118827);
                String[] display = mod.getDisplayNames();
                for (int i = 0; i < display.length && display[i] != null; ++i) {
                    fontR.func_175063_a(display[i], (float)(screenwidth / 2 - fontR.func_78256_a(display[i]) / 2), (float)(yCoord += 10), 0xFFFFFF);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                if (!retained) {
                    this.retainedTarget = ent;
                    this.healthBarRetainTime = System.currentTimeMillis() + 3000L;
                }
            } else {
                this.askServerMods((Entity)ent);
            }
        }
    }

    private LivingEntity getEntityCrosshairOver(float partialTicks, Minecraft mc) {
        Entity entity = mc.func_175606_aa();
        if (entity != null && mc.field_71441_e != null) {
            AxisAlignedBB axisalignedbb;
            double distance = 32.0;
            RayTraceResult result = entity.func_213324_a(distance, partialTicks, false);
            Vec3d vec3d = entity.func_174824_e(partialTicks);
            double distanceToHit = result.func_216347_e().func_72436_e(vec3d);
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
            EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a((Entity)entity, (Vec3d)vec3d, (Vec3d)vec3d2, (AxisAlignedBB)(axisalignedbb = entity.func_174813_aQ().func_216361_a(vec3d1.func_186678_a(distance)).func_72314_b(1.0, 1.0, 1.0)), p_lambda$getMouseOver$0_0_ -> !p_lambda$getMouseOver$0_0_.func_175149_v() && p_lambda$getMouseOver$0_0_.func_70067_L(), (double)distanceToHit);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.func_216348_a();
                Vec3d vec3d3 = entityraytraceresult.func_216347_e();
                double d2 = vec3d.func_72436_e(vec3d3);
                if (d2 < distanceToHit && entity1 instanceof LivingEntity) {
                    return (LivingEntity)entity1;
                }
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent tick) {
        if (this.mc.field_71441_e == null || this.mc.field_71462_r != null && this.mc.field_71462_r.isPauseScreen()) {
            return;
        }
        if (this.mc.field_71441_e != this.lastWorld) {
            boolean newGame = this.lastWorld == null;
            this.lastWorld = this.mc.field_71441_e;
            if (!newGame) {
                InfernalMobsCore.proxy.getRareMobs().clear();
            }
        }
    }

    @Override
    public ConcurrentHashMap<LivingEntity, MobModifier> getRareMobs() {
        return this.rareMobsClient;
    }

    @Override
    public void onHealthPacketForClient(int entID, float health, float maxhealth) {
        Minecraft.func_71410_x().func_213165_a(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.onHealthPacket(entID, health, maxhealth)));
    }

    private void onHealthPacket(int entID, float health, float maxhealth) {
        MobModifier mod;
        Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(entID);
        if (ent instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers((LivingEntity)ent)) != null) {
            mod.setActualHealth(health, maxhealth);
        }
    }

    @Override
    public void onKnockBackPacket(float xv, float zv) {
        Minecraft.func_71410_x().func_213165_a(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MM_Gravity.knockBack((LivingEntity)this.mc.field_71439_g, xv, zv)));
    }

    @Override
    public void onMobModsPacketToClient(String stringData, int entID) {
        InfernalMobsCore.instance().addRemoteEntityModifiers((World)this.mc.field_71441_e, entID, stringData);
    }

    @Override
    public void onVelocityPacket(float xv, float yv, float zv) {
        this.mc.func_213165_a(() -> this.mc.field_71439_g.func_70024_g((double)xv, (double)yv, (double)zv));
    }

    @Override
    public void onAirPacket(int air) {
        airOverrideValue = air;
        this.airDisplayTimeout = System.currentTimeMillis() + 3000L;
    }

    @Override
    public File getMcFolder() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @SubscribeEvent
    public void onTick(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            if (System.currentTimeMillis() > this.airDisplayTimeout) {
                airOverrideValue = -999;
            }
            if (!this.mc.field_71439_g.func_208600_a(FluidTags.field_206959_a) && airOverrideValue != -999) {
                GL11.glEnable((int)3042);
                int right_height = 39;
                int left = this.mc.func_228018_at_().func_198107_o() / 2 + 91;
                int top = this.mc.func_228018_at_().func_198087_p() - right_height;
                int full = MathHelper.func_76143_f((double)((double)(airOverrideValue - 2) * 10.0 / 300.0));
                int partial = MathHelper.func_76143_f((double)((double)airOverrideValue * 10.0 / 300.0)) - full;
                for (int i = 0; i < full + partial; ++i) {
                    this.mc.field_71456_v.blit(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                }
                GL11.glDisable((int)3042);
            }
        }
    }
}

