/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.EntityEventHandler;
import atomicstryker.infernalmobs.common.GsonConfig;
import atomicstryker.infernalmobs.common.ISidedProxy;
import atomicstryker.infernalmobs.common.InfernalCommandFindEntityClass;
import atomicstryker.infernalmobs.common.InfernalCommandSpawnInfernal;
import atomicstryker.infernalmobs.common.InfernalMobsConfig;
import atomicstryker.infernalmobs.common.InfernalMobsServer;
import atomicstryker.infernalmobs.common.ItemConfigHelper;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.SaveEventHandler;
import atomicstryker.infernalmobs.common.mods.MM_1UP;
import atomicstryker.infernalmobs.common.mods.MM_Alchemist;
import atomicstryker.infernalmobs.common.mods.MM_Berserk;
import atomicstryker.infernalmobs.common.mods.MM_Blastoff;
import atomicstryker.infernalmobs.common.mods.MM_Bulwark;
import atomicstryker.infernalmobs.common.mods.MM_Choke;
import atomicstryker.infernalmobs.common.mods.MM_Cloaking;
import atomicstryker.infernalmobs.common.mods.MM_Darkness;
import atomicstryker.infernalmobs.common.mods.MM_Ender;
import atomicstryker.infernalmobs.common.mods.MM_Exhaust;
import atomicstryker.infernalmobs.common.mods.MM_Fiery;
import atomicstryker.infernalmobs.common.mods.MM_Ghastly;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.mods.MM_Lifesteal;
import atomicstryker.infernalmobs.common.mods.MM_Ninja;
import atomicstryker.infernalmobs.common.mods.MM_Poisonous;
import atomicstryker.infernalmobs.common.mods.MM_Quicksand;
import atomicstryker.infernalmobs.common.mods.MM_Regen;
import atomicstryker.infernalmobs.common.mods.MM_Rust;
import atomicstryker.infernalmobs.common.mods.MM_Sapper;
import atomicstryker.infernalmobs.common.mods.MM_Sprint;
import atomicstryker.infernalmobs.common.mods.MM_Sticky;
import atomicstryker.infernalmobs.common.mods.MM_Storm;
import atomicstryker.infernalmobs.common.mods.MM_Vengeance;
import atomicstryker.infernalmobs.common.mods.MM_Weakness;
import atomicstryker.infernalmobs.common.mods.MM_Webber;
import atomicstryker.infernalmobs.common.mods.MM_Wither;
import atomicstryker.infernalmobs.common.network.AirPacket;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.KnockBackPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import atomicstryker.infernalmobs.common.network.VelocityPacket;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="infernalmobs")
@Mod.EventBusSubscriber(modid="infernalmobs")
public class InfernalMobsCore {
    static final String MOD_ID = "infernalmobs";
    public static Logger LOGGER;
    public static ISidedProxy proxy;
    private static InfernalMobsCore instance;
    private final long existCheckDelay = 5000L;
    public NetworkHelper networkHelper;
    protected File configFile;
    protected InfernalMobsConfig config;
    private long nextExistCheckTime;
    private ItemConfigHelper lootItemDropsElite;
    private ItemConfigHelper lootItemDropsUltra;
    private ItemConfigHelper lootItemDropsInfernal;
    private HashMap<String, Boolean> classesAllowedMap;
    private HashMap<String, Boolean> classesForcedMap;
    private HashMap<String, Double> classesHealthMap;
    private Entity infCheckA;
    private Entity infCheckB;
    private ArrayList<Class<? extends MobModifier>> mobMods;
    private ArrayList<Enchantment> enchantmentList;
    private HashMap<String, Long> modifiedPlayerTimes;

    public InfernalMobsCore() {
        instance = this;
        this.nextExistCheckTime = System.currentTimeMillis();
        this.classesAllowedMap = new HashMap();
        this.classesForcedMap = new HashMap();
        this.classesHealthMap = new HashMap();
        this.modifiedPlayerTimes = new HashMap();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SaveEventHandler());
        this.networkHelper = new NetworkHelper(MOD_ID, MobModsPacket.class, HealthPacket.class, VelocityPacket.class, KnockBackPacket.class, AirPacket.class);
        LOGGER = LogManager.getLogger();
    }

    public static InfernalMobsCore instance() {
        return instance;
    }

    public static MobModifier getMobModifiers(LivingEntity ent) {
        return proxy.getRareMobs().get(ent);
    }

    public static boolean getIsRareEntity(LivingEntity ent) {
        return proxy.getRareMobs().containsKey(ent);
    }

    public static void removeEntFromElites(LivingEntity entity) {
        proxy.getRareMobs().remove(entity);
    }

    public String getNBTTag() {
        return "InfernalMobsMod";
    }

    public void commonSetup(FMLCommonSetupEvent evt) {
        this.prepareModList();
        proxy.load();
        this.configFile = new File(proxy.getMcFolder(), File.separatorChar + "config" + File.separatorChar + "infernalmobs.cfg");
        this.loadConfig();
        LOGGER.info("InfernalMobsCore commonSetup completed! Modifiers ready: " + this.mobMods.size());
        LOGGER.info("InfernalMobsCore commonSetup completed! config file at: " + this.configFile.getAbsolutePath());
    }

    @SubscribeEvent
    public void serverStarted(FMLServerStartingEvent evt) {
        evt.getCommandDispatcher().register(InfernalCommandFindEntityClass.BUILDER);
        evt.getCommandDispatcher().register(InfernalCommandSpawnInfernal.BUILDER);
    }

    private void prepareModList() {
        this.mobMods = new ArrayList();
        this.mobMods.add(MM_1UP.class);
        this.mobMods.add(MM_Alchemist.class);
        this.mobMods.add(MM_Berserk.class);
        this.mobMods.add(MM_Blastoff.class);
        this.mobMods.add(MM_Bulwark.class);
        this.mobMods.add(MM_Choke.class);
        this.mobMods.add(MM_Cloaking.class);
        this.mobMods.add(MM_Darkness.class);
        this.mobMods.add(MM_Ender.class);
        this.mobMods.add(MM_Exhaust.class);
        this.mobMods.add(MM_Fiery.class);
        this.mobMods.add(MM_Ghastly.class);
        this.mobMods.add(MM_Gravity.class);
        this.mobMods.add(MM_Lifesteal.class);
        this.mobMods.add(MM_Ninja.class);
        this.mobMods.add(MM_Poisonous.class);
        this.mobMods.add(MM_Quicksand.class);
        this.mobMods.add(MM_Regen.class);
        this.mobMods.add(MM_Rust.class);
        this.mobMods.add(MM_Sapper.class);
        this.mobMods.add(MM_Sprint.class);
        this.mobMods.add(MM_Sticky.class);
        this.mobMods.add(MM_Storm.class);
        this.mobMods.add(MM_Vengeance.class);
        this.mobMods.add(MM_Weakness.class);
        this.mobMods.add(MM_Webber.class);
        this.mobMods.add(MM_Wither.class);
    }

    private void loadConfig() {
        InfernalMobsConfig defaultConfig = new InfernalMobsConfig();
        defaultConfig.setEliteRarity(15);
        defaultConfig.setUltraRarity(7);
        defaultConfig.setInfernoRarity(7);
        defaultConfig.setUseSimpleEntityClassNames(true);
        defaultConfig.setDisableHealthBar(false);
        defaultConfig.setModHealthFactor(1.0);
        ArrayList<String> dropsElite = new ArrayList<String>();
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151037_a)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151035_b)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151036_c)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151040_l)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151019_K)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151020_U)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151029_X)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151023_V)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151022_W)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151028_Y)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151167_ab)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151030_Z)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151165_aa)));
        dropsElite.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151106_aX, 5)));
        defaultConfig.setDroppedItemIDsElite(dropsElite);
        ArrayList<String> dropsUltra = new ArrayList<String>();
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151019_K)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151031_f)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151020_U)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151029_X)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151023_V)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151022_W)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151028_Y)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151167_ab)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151030_Z)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151165_aa)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151169_ag)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151151_aj)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151171_ah)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151149_ai)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151153_ao, 3)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151065_br, 5)));
        dropsUltra.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151134_bR)));
        defaultConfig.setDroppedItemIDsUltra(dropsUltra);
        ArrayList<String> dropsInfernal = new ArrayList<String>();
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151134_bR)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151045_i, 3)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151048_u)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151056_x)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151012_L)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151046_w)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151047_v)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151020_U)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151029_X)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151023_V)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151022_W)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151161_ac)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151175_af)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151163_ad)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151173_ae)));
        dropsInfernal.add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Items.field_151079_bi, 3)));
        defaultConfig.setDroppedItemIDsInfernal(dropsInfernal);
        defaultConfig.setMaxDamage(10.0);
        defaultConfig.setDimensionIDBlackList(new ArrayList<Integer>());
        HashMap<String, Boolean> modsEnabledMap = new HashMap<String, Boolean>();
        for (Class<? extends MobModifier> c2 : this.mobMods) {
            modsEnabledMap.put(c2.getSimpleName(), true);
        }
        defaultConfig.setModsEnabled(modsEnabledMap);
        this.config = GsonConfig.loadConfigWithDefault(InfernalMobsConfig.class, this.configFile, defaultConfig);
        this.lootItemDropsElite = new ItemConfigHelper(this.config.getDroppedItemIDsElite(), LOGGER);
        this.lootItemDropsUltra = new ItemConfigHelper(this.config.getDroppedItemIDsUltra(), LOGGER);
        this.lootItemDropsInfernal = new ItemConfigHelper(this.config.getDroppedItemIDsInfernal(), LOGGER);
        this.mobMods.removeIf(c -> !this.config.getModsEnabled().containsKey(c.getSimpleName()) || this.config.getModsEnabled().get(c.getSimpleName()) == false);
    }

    public void processEntitySpawn(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K && this.config != null && !InfernalMobsCore.getIsRareEntity(entity) && this.isClassAllowed(entity) && (instance.checkEntityClassForced(entity) || entity.field_70170_p.field_73012_v.nextInt(this.config.getEliteRarity()) == 0)) {
            try {
                MobModifier mod;
                Integer tEntityDim = entity.field_71093_bK.func_186068_a();
                if (!this.config.getDimensionIDBlackList().contains(tEntityDim) && (mod = instance.createMobModifiers(entity)) != null) {
                    proxy.getRareMobs().put(entity, mod);
                    mod.onSpawningComplete(entity);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "processEntitySpawn() threw an exception");
                e.printStackTrace();
            }
        }
    }

    private boolean isClassAllowed(LivingEntity entity) {
        if (entity instanceof IMob) {
            if (entity instanceof TameableEntity) {
                return false;
            }
            if (instance.checkEntityClassAllowed(entity)) {
                return true;
            }
        }
        return false;
    }

    private String getEntityNameSafe(Entity entity) {
        String result;
        try {
            result = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.func_200600_R()).func_110623_a();
        }
        catch (Exception e) {
            result = entity.getClass().getSimpleName();
            System.err.println("Entity of class " + result + " crashed when EntityList.getEntityString was queried, for shame! Using classname instead.");
            System.err.println("If this message is spamming too much for your taste set useSimpleEntityClassnames true in your Infernal Mobs config");
        }
        return result;
    }

    private boolean checkEntityClassAllowed(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesAllowedMap.containsKey(entName)) {
            return this.classesAllowedMap.get(entName);
        }
        boolean result = true;
        if (!this.config.getPermittedentities().containsKey(entName)) {
            this.config.getPermittedentities().put(entName, true);
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getPermittedentities().get(entName);
            this.classesAllowedMap.put(entName, result);
        }
        return result;
    }

    private boolean checkEntityClassForced(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesForcedMap.containsKey(entName)) {
            return this.classesForcedMap.get(entName);
        }
        boolean result = false;
        if (!this.config.getEntitiesalwaysinfernal().containsKey(entName)) {
            this.config.getEntitiesalwaysinfernal().put(entName, false);
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getEntitiesalwaysinfernal().get(entName);
            this.classesForcedMap.put(entName, result);
        }
        return result;
    }

    public double getMobClassMaxHealth(LivingEntity entity) {
        String entName;
        String string = entName = this.config.isUseSimpleEntityClassNames() ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesHealthMap.containsKey(entName)) {
            return this.classesHealthMap.get(entName);
        }
        double result = entity.func_110138_aP();
        if (!this.config.getEntitybasehealth().containsKey(entName)) {
            this.config.getEntitybasehealth().put(entName, Double.valueOf(entity.func_110138_aP()));
            GsonConfig.saveConfig(this.config, this.configFile);
        } else {
            result = this.config.getEntitybasehealth().get(entName);
            this.classesHealthMap.put(entName, result);
        }
        return result;
    }

    public void setEntityHealthPastMax(LivingEntity entity, float amount) {
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)amount);
        entity.func_70606_j(amount);
        instance.sendHealthPacket(entity);
    }

    private MobModifier createMobModifiers(LivingEntity entity) {
        int number = 2 + entity.field_70170_p.field_73012_v.nextInt(3);
        ArrayList possibleMods = Lists.newArrayList(this.mobMods);
        if (entity.field_70170_p.field_73012_v.nextInt(this.config.getUltraRarity()) == 0) {
            number += 3 + entity.field_70170_p.field_73012_v.nextInt(2);
            if (entity.field_70170_p.field_73012_v.nextInt(this.config.getInfernoRarity()) == 0) {
                number += 3 + entity.field_70170_p.field_73012_v.nextInt(2);
            }
        }
        MobModifier lastMod = null;
        while (number > 0 && !possibleMods.isEmpty()) {
            int index = entity.field_70170_p.field_73012_v.nextInt(possibleMods.size());
            MobModifier nextMod = null;
            try {
                nextMod = lastMod == null ? (MobModifier)((Class)possibleMods.get(index)).getConstructor(new Class[0]).newInstance(new Object[0]) : (MobModifier)((Class)possibleMods.get(index)).getConstructor(MobModifier.class).newInstance(lastMod);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean allowed = true;
            if (nextMod != null && nextMod.getBlackListMobClasses() != null) {
                for (Class<?> cl : nextMod.getBlackListMobClasses()) {
                    if (!entity.getClass().isAssignableFrom(cl)) continue;
                    allowed = false;
                    break;
                }
            }
            if (lastMod != null && lastMod.getModsNotToMixWith() != null) {
                for (Class<?> cl : lastMod.getModsNotToMixWith()) {
                    if (!lastMod.containsModifierClass(cl)) continue;
                    allowed = false;
                    break;
                }
            }
            possibleMods.remove(index);
            if (!allowed) continue;
            lastMod = nextMod;
            --number;
        }
        return lastMod;
    }

    public void addEntityModifiersByString(LivingEntity entity, String savedMods) {
        if (!InfernalMobsCore.getIsRareEntity(entity)) {
            MobModifier mod = this.stringToMobModifiers(savedMods);
            if (mod != null) {
                proxy.getRareMobs().put(entity, mod);
                mod.onSpawningComplete(entity);
                mod.setHealthAlreadyHacked(entity);
            } else {
                System.err.println("Infernal Mobs error, could not instantiate modifier " + savedMods);
            }
        }
    }

    private MobModifier stringToMobModifiers(String buffer) {
        MobModifier lastMod = null;
        String[] tokens = buffer.split("\\s");
        block2: for (int j = tokens.length - 1; j >= 0; --j) {
            String modName = tokens[j];
            MobModifier nextMod = null;
            for (Class<? extends MobModifier> c : this.mobMods) {
                try {
                    nextMod = lastMod == null ? c.getConstructor(new Class[0]).newInstance(new Object[0]) : c.getConstructor(MobModifier.class).newInstance(lastMod);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (nextMod == null || !nextMod.getModName().equals(modName)) continue;
                lastMod = nextMod;
                continue block2;
            }
        }
        return lastMod;
    }

    public void addRemoteEntityModifiers(World world, int entID, String mods) {
        Entity ent = world.func_73045_a(entID);
        if (ent != null) {
            this.addEntityModifiersByString((LivingEntity)ent, mods);
        }
    }

    public void dropLootForEnt(LivingEntity mob, MobModifier mods) {
        int xpDrop;
        for (int xpValue = 25; xpValue > 0; xpValue -= xpDrop) {
            xpDrop = ExperienceOrbEntity.func_70527_a((int)xpValue);
            mob.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(mob.field_70170_p, mob.func_226277_ct_(), mob.func_226278_cu_(), mob.func_226281_cx_(), xpDrop));
        }
        this.dropRandomEnchantedItems(mob, mods);
    }

    private void dropRandomEnchantedItems(LivingEntity mob, MobModifier mods) {
        int prefix;
        int modStr = mods.getModSize();
        int n = modStr <= 5 ? 0 : (prefix = modStr <= 10 ? 1 : 2);
        while (modStr > 0) {
            ItemStack itemStack = this.getRandomItem(mob, prefix);
            if (itemStack != null) {
                Item item = itemStack.func_77973_b();
                if (item instanceof EnchantedBookItem) {
                    itemStack = EnchantedBookItem.func_92111_a((EnchantmentData)this.getRandomEnchantment(mob.func_70681_au()));
                } else {
                    int usedStr = modStr - 5 > 0 ? 5 : modStr;
                    this.enchantRandomly(mob.field_70170_p.field_73012_v, itemStack, item.func_77619_b(), usedStr);
                }
                ItemEntity itemEnt = new ItemEntity(mob.field_70170_p, mob.func_226277_ct_(), mob.func_226278_cu_(), mob.func_226281_cx_(), itemStack);
                mob.field_70170_p.func_217376_c((Entity)itemEnt);
                modStr -= 5;
                continue;
            }
            --modStr;
        }
    }

    private EnchantmentData getRandomEnchantment(Random rand) {
        if (this.enchantmentList == null) {
            this.enchantmentList = new ArrayList(26);
            for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                if (enchantment == null || enchantment.field_77351_y == null) continue;
                this.enchantmentList.add(enchantment);
            }
        }
        Enchantment e = this.enchantmentList.get(rand.nextInt(this.enchantmentList.size()));
        int min = e.func_77319_d();
        int range = e.func_77325_b() - min;
        int lvl = min + rand.nextInt(range + 1);
        EnchantmentData ed = new EnchantmentData(e, lvl);
        return ed;
    }

    private void enchantRandomly(Random rand, ItemStack itemStack, int itemEnchantability, int modStr) {
        List enchantments = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)itemStack, (int)itemEnchantability, (boolean)true);
        if (enchantments != null) {
            Iterator iter = enchantments.iterator();
            for (int remainStr = (modStr + 1) / 2; iter.hasNext() && remainStr > 0; --remainStr) {
                EnchantmentData eData = (EnchantmentData)iter.next();
                itemStack.func_77966_a(eData.field_76302_b, eData.field_76303_c);
            }
        }
    }

    private ItemStack getRandomItem(LivingEntity mob, int prefix) {
        List<ItemStack> list = prefix == 0 ? InfernalMobsCore.instance.lootItemDropsElite.getItemStackList() : (prefix == 1 ? InfernalMobsCore.instance.lootItemDropsUltra.getItemStackList() : InfernalMobsCore.instance.lootItemDropsInfernal.getItemStackList());
        return list.size() > 0 ? list.get(mob.field_70170_p.field_73012_v.nextInt(list.size())).func_77946_l() : null;
    }

    public void sendVelocityPacket(ServerPlayerEntity target, float xVel, float yVel, float zVel) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new VelocityPacket(xVel, yVel, zVel), target);
        }
    }

    public void sendKnockBackPacket(ServerPlayerEntity target, float xVel, float zVel) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new KnockBackPacket(xVel, zVel), target);
        }
    }

    public void sendHealthPacket(LivingEntity mob) {
        this.networkHelper.sendPacketToAllAroundPoint(new HealthPacket("", mob.func_145782_y(), mob.func_110143_aJ(), mob.func_110138_aP()), new PacketDistributor.TargetPoint(mob.func_226277_ct_(), mob.func_226278_cu_(), mob.func_226281_cx_(), 32.0, mob.field_71093_bK));
    }

    public void sendHealthRequestPacket(String playerName, LivingEntity mob) {
        this.networkHelper.sendPacketToServer(new HealthPacket(playerName, mob.func_145782_y(), 0.0f, 0.0f));
    }

    public void sendAirPacket(ServerPlayerEntity target, int lastAir) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new AirPacket(lastAir), target);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent tick) {
        if (System.currentTimeMillis() > this.nextExistCheckTime) {
            this.nextExistCheckTime = System.currentTimeMillis() + 5000L;
            ConcurrentHashMap<LivingEntity, MobModifier> mobsmap = proxy.getRareMobs();
            mobsmap.keySet().stream().filter(this::filterMob).forEach(InfernalMobsCore::removeEntFromElites);
            this.resetModifiedPlayerEntitiesAsNeeded(tick.world);
        }
        if (!tick.world.field_72995_K) {
            this.infCheckA = null;
            this.infCheckB = null;
        }
    }

    private boolean filterMob(LivingEntity mob) {
        return !mob.func_70089_S() || mob.field_70170_p == null;
    }

    private void resetModifiedPlayerEntitiesAsNeeded(World world) {
        Iterator<Map.Entry<String, Long>> iterator = this.modifiedPlayerTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (System.currentTimeMillis() <= entry.getValue() + 10000L) continue;
            String username = entry.getKey();
            for (PlayerEntity player : world.func_217369_A()) {
                if (!player.func_200200_C_().getString().equals(username)) continue;
                for (Class<? extends MobModifier> c : this.mobMods) {
                    try {
                        MobModifier mod = c.getConstructor(new Class[0]).newInstance(new Object[0]);
                        mod.resetModifiedVictim(player);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            iterator.remove();
        }
    }

    public boolean getIsHealthBarDisabled() {
        return this.config.isDisableHealthBar();
    }

    public double getMobModHealthFactor() {
        return this.config.getModHealthFactor();
    }

    public float getLimitedDamage(float test) {
        return (float)Math.min((double)test, this.config.getMaxDamage());
    }

    public boolean getIsEntityAllowedTarget(Entity entity) {
        return !(entity instanceof FakePlayer);
    }

    public boolean isInfiniteLoop(LivingEntity mob, Entity entity) {
        if (mob == this.infCheckA && entity == this.infCheckB || mob == this.infCheckB && entity == this.infCheckA) {
            return true;
        }
        this.infCheckA = mob;
        this.infCheckB = entity;
        return false;
    }

    public HashMap<String, Long> getModifiedPlayerTimes() {
        return this.modifiedPlayerTimes;
    }

    static {
        proxy = (ISidedProxy)DistExecutor.runForDist(() -> InfernalMobsClient::new, () -> InfernalMobsServer::new);
    }
}

