/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MobModsPacket
implements NetworkHelper.IPacket {
    private String stringData;
    private int entID;
    private byte sentFromServer;

    public MobModsPacket() {
    }

    public MobModsPacket(String stringdata, int entIdToQuery, byte serverByte) {
        this.stringData = stringdata;
        this.entID = entIdToQuery;
        this.sentFromServer = serverByte;
    }

    @Override
    public void encode(Object msg, PacketBuffer packetBuffer) {
        MobModsPacket mobModsPacket = (MobModsPacket)msg;
        packetBuffer.writeByte((int)mobModsPacket.sentFromServer);
        packetBuffer.writeInt(mobModsPacket.entID);
        packetBuffer.func_211400_a(mobModsPacket.stringData, Short.MAX_VALUE);
    }

    @Override
    public <MSG> MSG decode(PacketBuffer packetBuffer) {
        MobModsPacket mobModsPacket = new MobModsPacket();
        mobModsPacket.sentFromServer = packetBuffer.readByte();
        mobModsPacket.entID = packetBuffer.readInt();
        mobModsPacket.stringData = packetBuffer.func_150789_c(Short.MAX_VALUE);
        return (MSG)mobModsPacket;
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        MobModsPacket mobModsPacket = (MobModsPacket)msg;
        if (mobModsPacket.sentFromServer != 0) {
            InfernalMobsCore.proxy.onMobModsPacketToClient(mobModsPacket.stringData, mobModsPacket.entID);
            InfernalMobsCore.LOGGER.debug("client received serverside mods {} for ent-ID {}", (Object)mobModsPacket.stringData, (Object)mobModsPacket.entID);
        } else {
            ServerPlayerEntity p = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(mobModsPacket.stringData);
            InfernalMobsCore.LOGGER.debug("player {} from string {} querying server for mods of entity id {}", (Object)p, (Object)mobModsPacket.stringData, (Object)mobModsPacket.entID);
            if (p != null) {
                LivingEntity e;
                MobModifier mod;
                Entity ent = p.field_70170_p.func_73045_a(mobModsPacket.entID);
                InfernalMobsCore.LOGGER.debug("resolves to entity {}", (Object)ent);
                if (ent instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers(e = (LivingEntity)ent)) != null) {
                    mobModsPacket.stringData = mod.getLinkedModNameUntranslated();
                    InfernalMobsCore.LOGGER.debug("server sending mods {} for ent-ID {}", (Object)mobModsPacket.stringData, (Object)mobModsPacket.entID);
                    InfernalMobsCore.instance().networkHelper.sendPacketToPlayer(new MobModsPacket(mobModsPacket.stringData, mobModsPacket.entID, 1), p);
                    InfernalMobsCore.instance().sendHealthPacket(e);
                }
            }
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

