/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.worldgen;

import com.inventorypets.InventoryPets;
import com.inventorypets.worldgen.WorldGenDungeon;
import com.inventorypets.worldgen.WorldGenNetherDungeon;
import com.inventorypets.worldgen.WorldGenSeaCave;
import com.inventorypets.worldgen.WorldGenSkyDungeon;
import com.inventorypets.worldgen.WorldGenSpaceDungeon;
import com.inventorypets.worldgen.WorldGenTreeTop;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenInventoryPets
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateOverworldDungeons(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                this.generateNetherDungeons(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateOverworldDungeons(World world, Random random, int BlockX, int BlockZ) {
        BlockPos bposchk = new BlockPos(BlockX, 0, BlockZ);
        Biome biomegenbase = world.func_180494_b(new BlockPos(BlockX, 60, BlockZ));
        if (!InventoryPets.disableAllDungeons && world.func_72912_H().func_76067_t() != WorldType.field_77138_c) {
            int Ycoord;
            int Zcoord;
            int Xcoord;
            int i;
            boolean makeDungeon;
            int fud;
            int BlockPosY;
            int dm;
            int fsd;
            if (!InventoryPets.disableSkyDungeons && (fsd = InventoryPets.frequencySkyDungeons) > 0 && fsd <= 10) {
                fsd *= fsd;
                dm = random.nextInt(1200);
                if (dm <= fsd) {
                    BlockPosY = 150;
                    new WorldGenSkyDungeon().func_180709_b(world, random, new BlockPos(BlockX, BlockPosY, BlockZ));
                }
            }
            if (!InventoryPets.disableTreeTops && (BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE))) {
                int ftt = InventoryPets.frequencyTreeTops;
                if ((BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) && random.nextInt(10) < 4) {
                    return;
                }
                if (ftt > 0 && ftt <= 10) {
                    for (int i2 = 0; i2 < ftt; ++i2) {
                        int dir = random.nextInt(2);
                        dir = dir == 0 ? 1 : -1;
                        int Xcoord2 = BlockX + (random.nextInt(3) + 3) * dir;
                        int Zcoord2 = BlockZ + (random.nextInt(3) + 3) * dir;
                        int Ycoord2 = 60 + random.nextInt(60);
                        new WorldGenTreeTop(false).func_180709_b(world, random, new BlockPos(Xcoord2, Ycoord2, Zcoord2));
                    }
                }
            }
            if (!InventoryPets.disableSeaCaveDungeons && BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextBoolean()) {
                fud = InventoryPets.frequencySeaCaveDungeons;
                makeDungeon = true;
                if (fud > 0 && fud <= 10) {
                    for (i = 10; i > fud; --i) {
                        if (random.nextBoolean()) continue;
                        makeDungeon = false;
                    }
                }
                if (makeDungeon) {
                    Xcoord = BlockX;
                    Zcoord = BlockZ;
                    Ycoord = random.nextInt(10);
                    Ycoord = 62;
                    new WorldGenSeaCave().func_180709_b(world, random, new BlockPos(Xcoord, Ycoord, Zcoord));
                }
            }
            if (!InventoryPets.disableUndergroundDungeons && random.nextBoolean()) {
                fud = InventoryPets.frequencyUndergroundDungeons;
                makeDungeon = true;
                if (fud > 0 && fud <= 10) {
                    for (i = 12; i > fud; --i) {
                        if (random.nextBoolean()) continue;
                        makeDungeon = false;
                    }
                }
                if (makeDungeon) {
                    Xcoord = BlockX;
                    Zcoord = BlockZ;
                    Ycoord = random.nextInt(10);
                    Ycoord = 10 + Ycoord;
                    new WorldGenDungeon().func_180709_b(world, random, new BlockPos(Xcoord, Ycoord, Zcoord));
                }
            }
            if (!InventoryPets.disableSpaceDungeons && (fsd = InventoryPets.frequencySpaceDungeons) > 0 && fsd <= 10) {
                fsd *= fsd;
                dm = random.nextInt(1200);
                if (dm <= fsd) {
                    BlockPosY = 250;
                    new WorldGenSpaceDungeon().func_180709_b(world, random, new BlockPos(BlockX, BlockPosY, BlockZ));
                }
            }
        }
    }

    private void generateNetherDungeons(World world, Random random, int BlockX, int BlockZ) {
        BlockPos bposchk = new BlockPos(BlockX, 26, BlockZ);
        if (!InventoryPets.disableAllDungeons && world.func_72912_H().func_76067_t() != WorldType.field_77138_c && world.func_180495_p(bposchk).func_177230_c() != null && world.func_180495_p(bposchk).func_177230_c() == Blocks.field_150353_l && !InventoryPets.disableNetherDungeons && random.nextBoolean()) {
            int dm;
            int fd = InventoryPets.frequencyNetherDungeons;
            boolean makeDungeon = true;
            if (fd > 0 && fd <= 10 && (dm = random.nextInt(175)) <= fd) {
                int Xcoord = BlockX;
                int Zcoord = BlockZ;
                int Ycoord = 26;
                new WorldGenNetherDungeon().func_180709_b(world, random, new BlockPos(Xcoord, Ycoord, Zcoord));
            }
        }
    }
}

