/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.worldgen;

import com.inventorypets.InventoryPets;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenTreeTop
extends WorldGenAbstractTree {
    private static IBlockState DEFAULT_TRUNK = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    private static IBlockState DEFAULT_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private IBlockState metaWood;
    private IBlockState metaLeaves;
    Random rand = new Random();

    public WorldGenTreeTop(boolean p_i2027_1_) {
        this(p_i2027_1_, 6, DEFAULT_TRUNK, DEFAULT_LEAF, false);
    }

    public WorldGenTreeTop(boolean p_i46446_1_, int p_i46446_2_, IBlockState p_i46446_3_, IBlockState p_i46446_4_, boolean p_i46446_5_) {
        super(p_i46446_1_);
        this.minTreeHeight = p_i46446_2_;
        this.metaWood = p_i46446_3_;
        this.metaLeaves = p_i46446_4_;
        this.vinesGrow = p_i46446_5_;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position2) {
        BlockPos position = new BlockPos(position2.func_177958_n() + 8, position2.func_177956_o(), position2.func_177952_p() + 8);
        Biome biomegenbase = worldIn.func_180494_b(new BlockPos((Vec3i)position2));
        if (biomegenbase != null && biomegenbase.toString().toLowerCase().contains("birch")) {
            this.metaLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
            this.metaWood = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
        } else if (biomegenbase != null && biomegenbase.toString().toLowerCase().contains("jungle")) {
            this.metaLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
            this.metaWood = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        } else if (biomegenbase != null && biomegenbase.toString().toLowerCase().contains("roofed")) {
            this.metaLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
            this.metaWood = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
        }
        int i = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(position.func_177977_b());
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g)) && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                this.func_175921_a(worldIn, position.func_177977_b());
                int k2 = 3;
                int l2 = 0;
                for (int i3 = position.func_177956_o() - k2 + i; i3 <= position.func_177956_o() + i; ++i3) {
                    int i4 = i3 - (position.func_177956_o() + i);
                    int j1 = l2 + 1 - i4 / 2;
                    for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                        int l1 = k1 - position.func_177958_n();
                        for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                            int j2 = i2 - position.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0)) continue;
                            BlockPos blockpos = new BlockPos(k1, i3, i2);
                            state = worldIn.func_180495_p(blockpos);
                            this.func_175903_a(worldIn, blockpos, this.metaLeaves);
                        }
                    }
                }
                for (int j3 = 0; j3 < i; ++j3) {
                    BlockPos upN = position.func_177981_b(j3);
                    state = worldIn.func_180495_p(upN);
                    if (j3 == i - 1) {
                        this.func_175903_a(worldIn, position.func_177981_b(j3), this.metaWood);
                        worldIn.func_175656_a(position.func_177981_b(j3 - 1), Blocks.field_150486_ae.func_176203_a(4));
                        TileEntityChest tileentitychest = (TileEntityChest)worldIn.func_175625_s(position.func_177981_b(j3 - 1));
                        this.func_175903_a(worldIn, position.func_177981_b(j3), Blocks.field_150350_a.func_176223_P());
                        this.func_175903_a(worldIn, position.func_177981_b(j3 + 1), this.metaLeaves);
                        for (int g = 1; g < tileentitychest.func_70302_i_(); ++g) {
                            int r;
                            int h;
                            if (g == 4) {
                                for (int loopy = 0; loopy <= 50; ++loopy) {
                                    int k;
                                    h = rand.nextInt(100);
                                    if (h >= 0 && h <= 19) {
                                        k = rand.nextInt(8);
                                        if (k == 0 && !InventoryPets.disableGhast) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petGhast, 1, 0));
                                            loopy = 50;
                                        } else if (k == 1 && !InventoryPets.disableCreeper) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petCreeper, 1, 0));
                                            loopy = 50;
                                        } else if (k == 2 && !InventoryPets.disableEnderman) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petEnderman, 1, 0));
                                            loopy = 50;
                                        } else if (k == 3 && !InventoryPets.disableIronGolem) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petIronGolem, 1, 0));
                                            loopy = 50;
                                        } else if (k == 4 && !InventoryPets.disableSnowGolem) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSnowGolem, 1, 0));
                                            loopy = 50;
                                        } else if (k == 5 && !InventoryPets.disableSpider) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSpider, 1, 0));
                                            loopy = 50;
                                        } else if (k == 6 && !InventoryPets.disableMagmaCube) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petMagmaCube, 1, 0));
                                            loopy = 50;
                                        } else if (k == 7 && !InventoryPets.disableBlaze) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petBlaze, 1, 0));
                                            loopy = 50;
                                        }
                                    }
                                    if (h >= 20 && h <= 49) {
                                        k = rand.nextInt(7);
                                        if (k == 0 && !InventoryPets.disableSheep) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSheep, 1, 0));
                                            loopy = 50;
                                        } else if (k == 1 && !InventoryPets.disableCow) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petCow, 1, 0));
                                            loopy = 50;
                                        } else if (k == 2 && !InventoryPets.disableChicken) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petChicken, 1, 0));
                                            loopy = 50;
                                        } else if (k == 3 && !InventoryPets.disablePig) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petPig, 1, 0));
                                            loopy = 50;
                                        } else if (k == 4 && !InventoryPets.disableSquid) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSquid, 1, 0));
                                            loopy = 50;
                                        } else if (k == 5 && !InventoryPets.disableOcelot) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petOcelot, 1, 0));
                                            loopy = 50;
                                        } else if (k == 6 && !InventoryPets.disableMooshroom) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petMooshroom, 1, 0));
                                            loopy = 50;
                                        }
                                    }
                                    if (h >= 50 && h <= 74) {
                                        k = rand.nextInt(13);
                                        if (k == 0 && !InventoryPets.disableFurnace) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petFurnace, 1, 0));
                                            loopy = 50;
                                        } else if (k == 1 && !InventoryPets.disableEnchantingTable) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petEnchantingTable, 1, 0));
                                            loopy = 50;
                                        } else if (k == 2 && !InventoryPets.disableCraftingTable) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petCraftingTable, 1, 0));
                                            loopy = 50;
                                        } else if (k == 3 && !InventoryPets.disableChest) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petChest, 1, 0));
                                            loopy = 50;
                                        } else if (k == 4 && !InventoryPets.disableDoubleChest) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petDoubleChest, 1, 0));
                                            loopy = 50;
                                        } else if (k == 5 && !InventoryPets.disableBed) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petBed, 1, 0));
                                            loopy = 50;
                                        } else if (k == 6 && !InventoryPets.disableJukebox) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petJukebox, 1, 0));
                                            loopy = 50;
                                        } else if (k == 7 && !InventoryPets.disableAnvil) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petAnvil, 1, 0));
                                            loopy = 50;
                                        } else if (k == 8 && !InventoryPets.disableBrewingStand) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petBrewingStand, 1, 0));
                                            loopy = 50;
                                        } else if (k == 9 && !InventoryPets.disableNetherPortal) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petNetherPortal, 1, 0));
                                            loopy = 50;
                                        } else if (k == 10 && !InventoryPets.disableEnderChest) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petEnderChest, 1, 0));
                                            loopy = 50;
                                        } else if (k == 11 && !InventoryPets.disableSaddle) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSaddle, 1, 0));
                                            loopy = 50;
                                        } else if (k == 12 && !InventoryPets.disableLead) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petLead, 1, 0));
                                            loopy = 50;
                                        }
                                    }
                                    if (h >= 75 && h <= 79) {
                                        k = rand.nextInt(11);
                                        if (k == 0 && !InventoryPets.disablePingot) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petPingot, 1, 0));
                                            loopy = 50;
                                        } else if (k == 1 && !InventoryPets.disableMickerson) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petMickerson, 1, 0));
                                            loopy = 50;
                                        } else if (k == 2 && !InventoryPets.disablePurpliciousCow) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petPurpliciousCow, 1, 0));
                                            loopy = 50;
                                        } else if (k == 3 && !InventoryPets.disableQuantumCrystalMonster) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petQuantumCrystalMonster, 1, 0));
                                            loopy = 50;
                                        } else if (k == 4 && !InventoryPets.disableBanana) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petBanana, 1, 0));
                                            loopy = 50;
                                        } else if (k == 5 && !InventoryPets.disableGrave) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petGrave, 1, 0));
                                            loopy = 50;
                                        } else if (k == 6 && !InventoryPets.disableQuiver) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petQuiver, 1, 0));
                                            loopy = 50;
                                        } else if (k == 7 && !InventoryPets.disableSponge) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSponge, 1, 0));
                                            loopy = 50;
                                        } else if (k == 8 && !InventoryPets.disableBiome) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petBiome, 1, 0));
                                            loopy = 50;
                                        } else if (k == 9 && !InventoryPets.disableLoot) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petLoot, 1, 0));
                                            loopy = 50;
                                        } else if (k == 10 && !InventoryPets.disableFlyingSaddle) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petFlyingSaddle, 1, 0));
                                            loopy = 50;
                                        }
                                    }
                                    if (h >= 80 && h <= 83) {
                                        k = rand.nextInt(5);
                                        if (k == 0 && !InventoryPets.disableJuggernaut) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petJuggernaut, 1, 0));
                                            loopy = 50;
                                        } else if (k == 1 && !InventoryPets.disableIlluminati) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petIlluminati, 1, 0));
                                            loopy = 50;
                                        } else if (k == 2 && !InventoryPets.disableSiamese) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSiamese, 1, 0));
                                            loopy = 50;
                                        } else if (k == 3 && !InventoryPets.disableDirt) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petDirt, 1, 0));
                                            loopy = 50;
                                        } else if (k == 4 && !InventoryPets.disableCobblestone) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petCobblestone, 1, 0));
                                            loopy = 50;
                                        }
                                    }
                                    if (h >= 84 && h <= 92) {
                                        k = rand.nextInt(8);
                                        if (k == 0 && !InventoryPets.disablePacMan) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petPacMan, 1, 0));
                                            loopy = 50;
                                        } else if (k == 1 && !InventoryPets.disableCheetah) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petCheetah, 1, 0));
                                            loopy = 50;
                                        } else if (k == 2 && !InventoryPets.disableHouse) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petHouse, 1, 0));
                                            loopy = 50;
                                        } else if (k == 3 && !InventoryPets.disableSilverfish) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSilverfish, 1, 0));
                                            loopy = 50;
                                        } else if (k == 4 && !InventoryPets.disableWolf) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petWolf, 1, 0));
                                            loopy = 50;
                                        } else if (k == 5 && !InventoryPets.disableApple) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petApple, 1, 0));
                                            loopy = 50;
                                        } else if (k == 6 && !InventoryPets.disableTorch) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petTorch, 1, 0));
                                            loopy = 50;
                                        } else if (k == 7 && !InventoryPets.disablePixie) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petPixie, 1, 0));
                                            loopy = 50;
                                        }
                                    }
                                    if (h >= 93 && h <= 98) {
                                        k = rand.nextInt(4);
                                        if (k == 0 && !InventoryPets.disableShield) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petShield, 1, 0));
                                            loopy = 50;
                                        } else if (k == 1 && !InventoryPets.disableDubstep) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petDubstep, 1, 0));
                                            loopy = 50;
                                        } else if (k == 2 && !InventoryPets.disableHeart) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petHeart, 1, 0));
                                            loopy = 50;
                                        } else if (k == 3 && !InventoryPets.disableMoon) {
                                            tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petMoon, 1, 0));
                                            loopy = 50;
                                        }
                                    }
                                    if (h < 99) continue;
                                    tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.petSun, 1, 0));
                                    loopy = 50;
                                }
                                continue;
                            }
                            if (g == 3 || g == 5) continue;
                            int chance = rand.nextInt(100);
                            h = rand.nextInt(67);
                            if (chance <= 35) continue;
                            if (h <= 49) {
                                if (h >= 0 && h <= 14) {
                                    r = rand.nextInt(1) + 1;
                                    tileentitychest.func_70299_a(g, new ItemStack(Items.field_151015_O, r, 0));
                                }
                                if (h >= 15 && h <= 30) {
                                    r = rand.nextInt(6) + 1;
                                    tileentitychest.func_70299_a(g, new ItemStack((Block)Blocks.field_150362_t, r, 0));
                                }
                                if (h >= 31 && h <= 43) {
                                    r = rand.nextInt(10) + 1;
                                    tileentitychest.func_70299_a(g, new ItemStack(Items.field_151127_ba, r, 0));
                                }
                                if (h >= 44 && h <= 44) {
                                    r = rand.nextInt(50);
                                    if (r == 0) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151086_cn, 1));
                                    } else if (r == 1) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151094_cf, 1));
                                    } else if (r == 2) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151091_cg, 1));
                                    } else if (r == 3) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151092_ch, 1));
                                    } else if (r == 4) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151090_cj, 1));
                                    } else if (r == 5) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151089_ci, 1));
                                    } else if (r == 6) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151087_ck, 1));
                                    } else if (r == 7) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151088_cl, 1));
                                    } else if (r == 8) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151084_co, 1));
                                    } else if (r == 9) {
                                        tileentitychest.func_70299_a(g, new ItemStack(Items.field_151085_cm, 1));
                                    }
                                }
                                if (h >= 45 && h <= 47) {
                                    r = rand.nextInt(1) + 1;
                                    tileentitychest.func_70299_a(g, new ItemStack(Items.field_151166_bC, r, 0));
                                }
                                if (h < 48 || h > 49) continue;
                                r = rand.nextInt(1) + 1;
                                tileentitychest.func_70299_a(g, new ItemStack(Items.field_151045_i, r, 0));
                                continue;
                            }
                            if (h >= 50 && h <= 50) {
                                r = rand.nextInt(4) + 1;
                                tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.nuggetEmerald, r, 0));
                            }
                            if (h >= 51 && h <= 51) {
                                r = rand.nextInt(4) + 1;
                                tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.nuggetDiamond, r, 0));
                            }
                            if (h >= 52 && h <= 53) {
                                r = rand.nextInt(4) + 1;
                                tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.nuggetEnder, r, 0));
                            }
                            if (h >= 54 && h <= 57) {
                                r = rand.nextInt(4) + 1;
                                tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.nuggetLapis, r, 0));
                            }
                            if (h >= 58 && h <= 61) {
                                r = rand.nextInt(4) + 1;
                                tileentitychest.func_70299_a(g, new ItemStack(InventoryPets.nuggetObsidian, r, 0));
                            }
                            if (h < 62 || h > 66) continue;
                            r = rand.nextInt(4) + 1;
                            tileentitychest.func_70299_a(g, new ItemStack(Items.field_191525_da, r, 0));
                        }
                    }
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, upN) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, upN) && state.func_185904_a() != Material.field_151582_l) continue;
                    if (j3 != i - 1) {
                        this.func_175903_a(worldIn, position.func_177981_b(j3), this.metaWood);
                    }
                    if (!this.vinesGrow || j3 <= 0) continue;
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(-1, j3, 0))) {
                        this.addVine(worldIn, position.func_177982_a(-1, j3, 0), BlockVine.field_176278_M);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(1, j3, 0))) {
                        this.addVine(worldIn, position.func_177982_a(1, j3, 0), BlockVine.field_176280_O);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(0, j3, -1))) {
                        this.addVine(worldIn, position.func_177982_a(0, j3, -1), BlockVine.field_176279_N);
                    }
                    if (rand.nextInt(3) <= 0 || !worldIn.func_175623_d(position.func_177982_a(0, j3, 1))) continue;
                    this.addVine(worldIn, position.func_177982_a(0, j3, 1), BlockVine.field_176273_b);
                }
                if (this.vinesGrow) {
                    for (int k3 = position.func_177956_o() - 3 + i; k3 <= position.func_177956_o() + i; ++k3) {
                        int j4 = k3 - position.func_177956_o() + i;
                        int k4 = 2 - j4 / 2;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                        for (int l4 = position.func_177958_n() - k4; l4 <= position.func_177958_n() + k4; ++l4) {
                            for (int i5 = position.func_177952_p() - k4; i5 <= position.func_177952_p() + k4; ++i5) {
                                blockpos$mutableblockpos1.func_181079_c(l4, k3, i5);
                                state = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1);
                                if (!state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos1)) continue;
                                BlockPos blockpos2 = blockpos$mutableblockpos1.func_177976_e();
                                BlockPos blockpos3 = blockpos$mutableblockpos1.func_177974_f();
                                BlockPos blockpos4 = blockpos$mutableblockpos1.func_177978_c();
                                BlockPos blockpos1 = blockpos$mutableblockpos1.func_177968_d();
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos2)) {
                                    this.addHangingVine(worldIn, blockpos2, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos3)) {
                                    this.addHangingVine(worldIn, blockpos3, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(blockpos4)) {
                                    this.addHangingVine(worldIn, blockpos4, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !worldIn.func_175623_d(blockpos1)) continue;
                                this.addHangingVine(worldIn, blockpos1, BlockVine.field_176273_b);
                            }
                        }
                    }
                    if (rand.nextInt(5) == 0 && i > 5) {
                        for (int l3 = 0; l3 < 2; ++l3) {
                            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                                if (rand.nextInt(4 - l3) != 0) continue;
                                EnumFacing enumfacing1 = enumfacing.func_176734_d();
                                this.placeCocoa(worldIn, rand.nextInt(3), position.func_177982_a(enumfacing1.func_82601_c(), i - 5 + l3, enumfacing1.func_82599_e()), enumfacing);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeCocoa(World p_181652_1_, int p_181652_2_, BlockPos p_181652_3_, EnumFacing p_181652_4_) {
        this.func_175903_a(p_181652_1_, p_181652_3_, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(p_181652_2_)).func_177226_a((IProperty)BlockCocoa.field_185512_D, (Comparable)p_181652_4_));
    }

    private void addVine(World p_181651_1_, BlockPos p_181651_2_, PropertyBool p_181651_3_) {
        this.func_175903_a(p_181651_1_, p_181651_2_, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)p_181651_3_, (Comparable)Boolean.valueOf(true)));
    }

    private void addHangingVine(World p_181650_1_, BlockPos p_181650_2_, PropertyBool p_181650_3_) {
        this.addVine(p_181650_1_, p_181650_2_, p_181650_3_);
        p_181650_2_ = p_181650_2_.func_177977_b();
        for (int i = 4; p_181650_1_.func_175623_d(p_181650_2_) && i > 0; --i) {
            this.addVine(p_181650_1_, p_181650_2_, p_181650_3_);
            p_181650_2_ = p_181650_2_.func_177977_b();
        }
    }
}

