/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets;

import com.inventorypets.ContainerChests;
import com.inventorypets.InventoryChestPet;
import com.inventorypets.InventoryPets;
import com.inventorypets.NBTHelper;
import com.inventorypets.StackUtils;
import com.inventorypets.petChest;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ChestContainer
extends ContainerChests {
    public static int NORMALLines = 3;
    public static int NORMALColumns = 9;
    int startX = 0;
    int startY = 0;
    private final EntityPlayer entityPlayer;
    public final InventoryChestPet inventoryChest;
    private int blockedSlot;
    private int chestInventoryRows;
    private int chestInventoryColumns;
    boolean foid = false;
    String color;

    public ChestContainer(EntityPlayer entityPlayer, InventoryChestPet inventoryChest) {
        this.entityPlayer = entityPlayer;
        this.inventoryChest = inventoryChest;
        this.chestInventoryRows = NORMALLines;
        this.chestInventoryColumns = NORMALColumns;
        this.startX = 8;
        this.startY = 18;
        int i = 0;
        for (int chestRowIndex = 0; chestRowIndex < this.chestInventoryRows; ++chestRowIndex) {
            for (int chestColumnIndex = 0; chestColumnIndex < this.chestInventoryColumns; ++chestColumnIndex) {
                this.func_75146_a(new SlotChest(this, inventoryChest, entityPlayer, chestColumnIndex + chestRowIndex * this.chestInventoryColumns, this.startX + chestColumnIndex * 18, this.startY + chestRowIndex * 18));
                ++i;
            }
        }
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)entityPlayer.field_71071_by, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 85 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)entityPlayer.field_71071_by, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 143));
        }
        this.blockedSlot = entityPlayer.field_71071_by.field_70461_c + 27 + i;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            InventoryPlayer invPlayer = player.field_71071_by;
            for (ItemStack itemStack : invPlayer.field_70462_a) {
                if (itemStack == null || !NBTHelper.hasTag(itemStack, "chestOpen")) continue;
                NBTHelper.removeTag(itemStack, "chestOpen");
            }
            this.saveInventory(player);
        }
    }

    public boolean isItemStackParent(ItemStack itemStack) {
        if (NBTHelper.hasUUID(itemStack)) {
            UUID stackUUID = new UUID(itemStack.func_77978_p().func_74763_f("UUIDMostSig"), itemStack.func_77978_p().func_74763_f("UUIDLeastSig"));
            return this.inventoryChest.matchesUUID(stackUUID);
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer p, int slotIndex) {
        if (!this.foid) {
            ItemStack newItemStack = null;
            Slot slot = (Slot)this.field_75151_b.get(slotIndex);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemStack = slot.func_75211_c();
                newItemStack = itemStack.func_77946_l();
                if (slotIndex < this.chestInventoryRows * this.chestInventoryColumns ? !this.func_75135_a(itemStack, this.chestInventoryRows * this.chestInventoryColumns, this.field_75151_b.size(), false) : (itemStack.func_77973_b() instanceof petChest ? (slotIndex < this.chestInventoryRows * this.chestInventoryColumns + 27 ? !this.func_75135_a(itemStack, this.chestInventoryRows * this.chestInventoryColumns + 27, this.field_75151_b.size(), false) : !this.func_75135_a(itemStack, this.chestInventoryRows * this.chestInventoryColumns, this.chestInventoryRows * this.chestInventoryColumns + 27, false)) : !this.func_75135_a(itemStack, 0, this.chestInventoryRows * this.chestInventoryColumns, false))) {
                    return null;
                }
                if (itemStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
            }
            return newItemStack;
        }
        return this.transferVoid(p, slotIndex);
    }

    private ItemStack transferVoid(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int numSlots = this.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.field_77994_a <= 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return originalStack;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (!slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || !StackUtils.isIdenticalItem(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                if (resultingStackSize <= max) {
                    stackToShift.field_77994_a = 0;
                    stackInSlot.field_77994_a = resultingStackSize;
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.field_77994_a >= max) continue;
                stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
                stackInSlot.field_77994_a = max;
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.field_77994_a > 0) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
                stackToShift.field_77994_a -= stackInSlot.field_77994_a;
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    public void saveInventory(EntityPlayer player) {
        this.inventoryChest.onGuiSaved(player);
    }

    public int getNumColumns() {
        return this.chestInventoryRows;
    }

    public ItemStack func_75144_a(int slotID, int clickedButton, int mode, EntityPlayer player) {
        if (slotID == this.blockedSlot) {
            return null;
        }
        return super.func_75144_a(slotID, clickedButton, mode, player);
    }

    private class SlotChest
    extends Slot {
        private final EntityPlayer entityPlayer;
        private ChestContainer containerChest;

        public SlotChest(ChestContainer containerChest, IInventory inventory, EntityPlayer entityPlayer, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.entityPlayer = entityPlayer;
            this.containerChest = containerChest;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (!ChestContainer.this.foid && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                this.containerChest.saveInventory(this.entityPlayer);
            }
        }

        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack == null) {
                return true;
            }
            itemStack = itemStack.func_77946_l();
            itemStack.field_77994_a = 1;
            return itemStack.func_77973_b() != InventoryPets.petChest && itemStack.func_77973_b() != InventoryPets.petDoubleChest && itemStack.func_77973_b() != InventoryPets.petEnderChest;
        }
    }
}

