/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets;

import com.inventorypets.CanTagNBT;
import com.inventorypets.ChestTypes;
import com.inventorypets.NBTHelper;
import com.inventorypets.petChest;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryChestPet
implements IInventory,
CanTagNBT {
    public ItemStack parentItemStack;
    protected ItemStack[] inventory;
    public ItemStack[] itemSlots = new ItemStack[64];
    protected String customName;
    public NBTTagCompound tag;
    public static boolean instantAdd = false;
    private boolean added = false;
    public ItemStack item;
    boolean foid = false;
    public int stackSize;

    public InventoryChestPet(ItemStack itemStack) {
        petChest item = (petChest)itemStack.func_77973_b();
        int size = 27;
        if (item.getType() == ChestTypes.NORMAL) {
            size = 27;
        } else if (item.getType() == ChestTypes.DOUBLE) {
            size = 54;
        }
        this.inventory = new ItemStack[size];
        this.parentItemStack = itemStack;
        if (!this.foid) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.tag = itemStack.func_77978_p();
            this.item = itemStack;
            this.readFromNBT(itemStack.func_77978_p());
        } else {
            this.itemSlots = new ItemStack[size];
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.tag = itemStack.func_77978_p();
            this.item = itemStack;
            this.stackSize = 64;
        }
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        this.parentItemStack = this.findParentItemStack(entityPlayer);
        if (this.parentItemStack != null) {
            this.save();
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (NBTHelper.hasUUID(this.parentItemStack)) {
            UUID parentItemStackUUID = new UUID(this.parentItemStack.func_77978_p().func_74763_f("UUIDMostSig"), this.parentItemStack.func_77978_p().func_74763_f("UUIDLeastSig"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (!NBTHelper.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("UUIDMostSig") != parentItemStackUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("UUIDLeastSig") != parentItemStackUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return null;
    }

    public boolean matchesUUID(UUID uuid) {
        return NBTHelper.hasUUID(this.parentItemStack) && this.parentItemStack.func_77978_p().func_74763_f("UUIDLeastSig") == uuid.getLeastSignificantBits() && this.parentItemStack.func_77978_p().func_74763_f("UUIDMostSig") == uuid.getMostSignificantBits();
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parentItemStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            UUID uuid = UUID.randomUUID();
            nbtTagCompound.func_74772_a("UUIDMostSig", uuid.getMostSignificantBits());
            nbtTagCompound.func_74772_a("UUIDLeastSig", uuid.getLeastSignificantBits());
        }
        this.writeToNBT(nbtTagCompound);
        this.parentItemStack.func_77982_d(nbtTagCompound);
    }

    public int func_70302_i_() {
        if (!this.foid) {
            return this.inventory.length;
        }
        return 65;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (!this.foid) {
            return this.inventory[slotIndex];
        }
        return slotIndex == 64 ? null : this.itemSlots[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        if (!this.foid) {
            ItemStack itemStack = this.func_70301_a(slotIndex);
            if (itemStack != null) {
                if (itemStack.field_77994_a <= decrementAmount) {
                    this.func_70299_a(slotIndex, null);
                } else {
                    itemStack = itemStack.func_77979_a(decrementAmount);
                    if (itemStack.field_77994_a == 0) {
                        this.func_70299_a(slotIndex, null);
                    }
                }
            }
            return itemStack;
        }
        if (slotIndex == 64) {
            return null;
        }
        if (this.itemSlots[slotIndex] != null) {
            if (this.itemSlots[slotIndex].field_77994_a <= decrementAmount) {
                ItemStack itemstack = this.itemSlots[slotIndex];
                this.itemSlots[slotIndex] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.itemSlots[slotIndex].func_77979_a(decrementAmount);
            if (this.itemSlots[slotIndex].field_77994_a == 0) {
                this.itemSlots[slotIndex] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (!this.foid) {
            this.inventory[slotIndex] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
        } else if (slotIndex != 64) {
            this.itemSlots[slotIndex] = itemStack;
            this.func_70296_d();
            if (instantAdd) {
                this.processInv();
            } else {
                this.added = true;
            }
        }
    }

    public void processInv() {
        if (this.itemSlots[0] != null) {
            this.itemSlots[0] = null;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.writeToNBT(this.tag);
        this.setNBT(this.item);
    }

    public void setNBT(ItemStack item) {
        item.func_77982_d(this.tag);
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70295_k_() {
        this.readFromNBT(this.tag);
    }

    public void func_70305_f() {
        this.writeToNBT(this.tag);
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (!this.foid) {
            return true;
        }
        return slotIndex <= 64;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        block4: {
            block3: {
                if (this.foid) break block3;
                if (nbtTagCompound == null || !nbtTagCompound.func_74764_b("Items")) break block4;
                if (nbtTagCompound.func_74764_b("Items")) {
                    NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
                    this.inventory = new ItemStack[this.func_70302_i_()];
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound tagCompound = tagList.func_150305_b(i);
                        byte slotIndex = tagCompound.func_74771_c("Slot");
                        if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
                        this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
                    }
                }
                if (!nbtTagCompound.func_74764_b("display") || !nbtTagCompound.func_74781_a("display").getClass().equals(NBTTagCompound.class) || !nbtTagCompound.func_74775_l("display").func_74764_b("Name")) break block4;
                this.customName = nbtTagCompound.func_74775_l("display").func_74779_i("Name");
                break block4;
            }
            this.itemSlots = new ItemStack[this.func_70302_i_()];
            NBTTagList inventory = nbtTagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < inventory.func_74745_c(); ++i) {
                NBTTagCompound Slots = inventory.func_150305_b(i);
                byte slot = Slots.func_74771_c("Slot");
                if (slot < 0 || slot >= this.itemSlots.length) continue;
                this.itemSlots[slot] = ItemStack.func_77949_a((NBTTagCompound)Slots);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        if (!this.foid) {
            NBTTagList tagList = new NBTTagList();
            for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
                if (this.inventory[currentIndex] == null) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)currentIndex);
                this.inventory[currentIndex].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
        } else {
            NBTTagList inventory = new NBTTagList();
            for (int slot = 0; slot < this.itemSlots.length; ++slot) {
                if (this.itemSlots[slot] == null) continue;
                NBTTagCompound Slots = new NBTTagCompound();
                Slots.func_74774_a("Slot", (byte)slot);
                this.itemSlots[slot].func_77955_b(Slots);
                inventory.func_74742_a((NBTBase)Slots);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)inventory);
            this.processInv();
        }
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String getCustomName() {
        return this.customName;
    }

    public String func_145825_b() {
        if (this.func_145818_k_()) {
            return this.getCustomName();
        }
        return "container.chest:Chests";
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemstack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return itemstack;
    }

    @Override
    public String getTagLabel() {
        return "InventoryChestPet";
    }
}

