/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.kiwi.block.IModBlock;

public class BlockMod
extends Block
implements IModBlock {
    private final String name;

    public BlockMod(String name, Material materialIn) {
        this(name, materialIn, BlockMod.deduceSoundType(materialIn));
    }

    public BlockMod(String name, Material materialIn, SoundType soundType) {
        super(materialIn);
        this.name = name;
        this.func_149672_a(soundType);
        this.func_149711_c(BlockMod.deduceHardness(materialIn));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        for (int i = 0; i < this.getItemSubtypeAmount(); ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    @Override
    public void register(String modid) {
        this.setRegistryName(modid, this.getName());
        this.func_149663_c(modid + "." + this.getName());
    }

    @Override
    public Block cast() {
        return this;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.getItemSubtypeAmount(); ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public static SoundType deduceSoundType(Material material) {
        if (material == Material.field_151575_d || material == Material.field_151572_C) {
            return SoundType.field_185848_a;
        }
        if (material == Material.field_151578_c || material == Material.field_151571_B) {
            return SoundType.field_185849_b;
        }
        if (material == Material.field_151585_k || material == Material.field_151577_b || material == Material.field_151584_j || material == Material.field_151582_l || material == Material.field_151583_m || material == Material.field_151590_u) {
            return SoundType.field_185850_c;
        }
        if (material == Material.field_151573_f) {
            return SoundType.field_185852_e;
        }
        if (material == Material.field_151592_s || material == Material.field_151567_E || material == Material.field_151588_w || material == Material.field_151598_x || material == Material.field_151591_t) {
            return SoundType.field_185853_f;
        }
        if (material == Material.field_151580_n || material == Material.field_151593_r || material == Material.field_151570_A || material == Material.field_151568_F || material == Material.field_151581_o) {
            return SoundType.field_185854_g;
        }
        if (material == Material.field_151595_p) {
            return SoundType.field_185855_h;
        }
        if (material == Material.field_151597_y || material == Material.field_151596_z) {
            return SoundType.field_185856_i;
        }
        if (material == Material.field_151574_g) {
            return SoundType.field_185858_k;
        }
        return SoundType.field_185851_d;
    }

    public static float deduceHardness(Material material) {
        if (material == Material.field_151585_k || material == Material.field_151594_q || material == Material.field_151579_a) {
            return 0.0f;
        }
        if (material == Material.field_151576_e) {
            return 2.5f;
        }
        if (material == Material.field_151575_d) {
            return 2.0f;
        }
        if (material == Material.field_151577_b) {
            return 0.6f;
        }
        if (material == Material.field_151595_p || material == Material.field_151578_c || material == Material.field_151571_B) {
            return 0.5f;
        }
        if (material == Material.field_151592_s) {
            return 0.3f;
        }
        if (material == Material.field_151573_f || material == Material.field_151574_g) {
            return 5.0f;
        }
        if (material == Material.field_151569_G) {
            return 4.0f;
        }
        if (material == Material.field_151580_n) {
            return 0.8f;
        }
        if (material == Material.field_151586_h || material == Material.field_151587_i) {
            return 100.0f;
        }
        return 1.0f;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.field_149764_J == Material.field_151575_d) {
            return 20;
        }
        if (this.field_149764_J == Material.field_151585_k) {
            return 100;
        }
        if (this.field_149764_J == Material.field_151593_r) {
            return 20;
        }
        if (this.field_149764_J == Material.field_151582_l) {
            return 100;
        }
        if (this.field_149764_J == Material.field_151584_j) {
            return 60;
        }
        if (this.field_149764_J == Material.field_151580_n) {
            return 60;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.field_149764_J == Material.field_151575_d) {
            return 5;
        }
        if (this.field_149764_J == Material.field_151585_k) {
            return 60;
        }
        if (this.field_149764_J == Material.field_151593_r) {
            return 60;
        }
        if (this.field_149764_J == Material.field_151582_l) {
            return 15;
        }
        if (this.field_149764_J == Material.field_151584_j) {
            return 30;
        }
        if (this.field_149764_J == Material.field_151580_n) {
            return 30;
        }
        return 0;
    }
}

