/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.kiwi.Kiwi;
import snownee.kiwi.item.IVariant;
import snownee.kiwi.util.VariantsHolder;

@SideOnly(value=Side.CLIENT)
public final class ModelUtil {
    private ModelUtil() {
        throw new UnsupportedOperationException();
    }

    public static void mapItemModel(Item item) {
        ResourceLocation registryName;
        if (item == null || (registryName = item.getRegistryName()) == null) {
            Kiwi.logger.warn("Detecting unnamed item {}, skip its model setup", (Object)item);
            return;
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(registryName, "inventory"));
    }

    public static void mapItemVariantsModel(Item item, String prefix, List<? extends VariantsHolder.Variant<? extends IStringSerializable>> variants, String suffix) {
        String modID = Objects.requireNonNull(item.getRegistryName()).func_110624_b();
        variants.forEach(variant -> ModelLoader.setCustomModelResourceLocation((Item)item, (int)variant.getMeta(), (ModelResourceLocation)new ModelResourceLocation(modID + ":" + prefix + variant.getValue().func_176610_l() + suffix, "inventory")));
    }

    public static void mapItemVariantsModelNew(Item item, String prefix, IVariant<?>[] variants, String suffix) {
        String modID = Objects.requireNonNull(item.getRegistryName()).func_110624_b();
        Arrays.asList(variants).forEach(variant -> ModelLoader.setCustomModelResourceLocation((Item)item, (int)variant.getMeta(), (ModelResourceLocation)new ModelResourceLocation(modID + ":" + prefix + variant.getName() + suffix, "inventory")));
    }

    public static void mapFluidModel(BlockFluidBase fluidBlock) {
        Fluid fluid = fluidBlock.getFluid();
        String modID = Objects.requireNonNull(fluidBlock.getRegistryName()).func_110624_b();
        FluidCustomModelMapper mapper = new FluidCustomModelMapper(modID, fluid);
        ModelLoader.setCustomStateMapper((Block)fluidBlock, (IStateMapper)mapper);
    }

    public static class FluidCustomModelMapper
    extends StateMapperBase {
        private final ModelResourceLocation res;

        FluidCustomModelMapper(String modid, Fluid f) {
            this.res = new ModelResourceLocation(new ResourceLocation(modid, "fluid"), f.getName());
        }

        public ModelResourceLocation func_178132_a(IBlockState state) {
            return this.res;
        }
    }
}

