/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client.gui.component;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import snownee.kiwi.client.gui.GuiControl;
import snownee.kiwi.client.gui.component.Component;

public abstract class ComponentList
extends Component {
    protected final int screenWidth;
    protected final int screenHeight;
    protected int mouseX;
    protected int mouseY;
    protected int offsetX;
    protected int offsetY;
    private float initialMouseClickY = -2.0f;
    private float scrollFactor;
    protected float scrollDistance;
    public int selectedIndex = -1;
    protected int hoveringIndex = -1;
    private long lastClickTime = 0L;
    private boolean highlightSelected = true;
    private boolean hasHeader;
    private int headerHeight;
    protected boolean captureMouse = true;
    private int cacheContentHeight;
    protected boolean drawBackground = true;
    protected boolean drawScrollbar = true;

    public ComponentList(GuiControl parent, int width, int height, int left, int top, int screenWidth, int screenHeight) {
        super(parent, width, height);
        this.top = top;
        this.left = left;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    protected void setHeaderInfo(boolean hasHeader, int headerHeight) {
        this.hasHeader = hasHeader;
        this.headerHeight = headerHeight;
        if (!hasHeader) {
            this.headerHeight = 0;
        }
    }

    protected void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    protected void setDrawScrollBar(boolean drawScrollbar) {
        this.drawScrollbar = drawScrollbar;
    }

    protected abstract int getSize();

    protected abstract int getSlotHeight(int var1);

    protected abstract void elementClicked(int var1, int var2, int var3, boolean var4);

    protected int getContentHeight() {
        return this.cacheContentHeight;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
    }

    protected void clickHeader(int x, int y) {
    }

    private void applyScrollLimits() {
        int listHeight = this.getContentHeight() - this.height;
        if (listHeight < 0) {
            listHeight = 0;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)listHeight) {
            this.scrollDistance = listHeight;
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            // empty if block
        }
    }

    @Override
    public void handleMouseInput(int mouseX, int mouseY) {
        boolean isHovering;
        boolean bl = isHovering = mouseX >= this.left && mouseX <= this.left + this.width && mouseY >= this.top && mouseY <= this.top + this.height;
        if (!isHovering) {
            return;
        }
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            this.scrollDistance += (float)(-1 * scroll) / 120.0f * (float)this.cacheContentHeight / (float)this.getSize() / 2.0f;
        }
    }

    @Override
    public void drawScreen(int offsetX, int offsetY, int relMouseX, int relMouseY, float partialTicks) {
        boolean isHovering;
        this.offsetX = this.left + offsetX;
        this.offsetY = this.top + offsetY;
        if (this.cacheContentHeight == 0) {
            this.cacheContentHeight();
        }
        this.mouseX = relMouseX;
        this.mouseY = relMouseY;
        this.drawBackground();
        boolean bl = isHovering = this.mouseX >= this.left && this.mouseX <= this.left + this.width && this.mouseY >= this.top && this.mouseY <= this.top + this.height;
        if (!isHovering) {
            this.hoveringIndex = -1;
        }
        int listLength = this.getSize();
        int scrollBarWidth = 6;
        int scrollBarRight = this.left + this.width;
        int scrollBarLeft = this.drawScrollbar ? scrollBarRight - scrollBarWidth : scrollBarRight;
        int entryRight = scrollBarLeft - 1;
        int border = 0;
        boolean clicked = false;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                if (isHovering) {
                    int mouseListY = this.mouseY - this.top - this.headerHeight + (int)this.scrollDistance - border;
                    if (this.mouseX >= this.left && this.mouseX <= entryRight && mouseListY >= 0) {
                        if (mouseListY >= 0) {
                            if (this.hoveringIndex >= 0 && this.hoveringIndex < listLength) {
                                clicked = true;
                            }
                        } else {
                            this.clickHeader(this.mouseX - this.left, this.mouseY - this.top + (int)this.scrollDistance - border);
                        }
                    }
                    if (this.mouseX >= scrollBarLeft && this.mouseX <= scrollBarRight) {
                        int var13;
                        this.scrollFactor = -1.0f;
                        int scrollHeight = this.getContentHeight() - this.height - border;
                        if (scrollHeight < 1) {
                            scrollHeight = 1;
                        }
                        if ((var13 = (int)((float)(this.height * this.height) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > this.height - border * 2) {
                            var13 = this.height - border * 2;
                        }
                        this.scrollFactor /= (float)(this.height - var13) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = this.mouseY;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)this.mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = this.mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        worldr.func_178969_c((double)offsetX, (double)offsetY, 0.0);
        ScaledResolution res = new ScaledResolution(this.parent.mc);
        double scaleW = (double)this.parent.mc.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.parent.mc.field_71440_d / res.func_78324_d();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.offsetX * scaleW)), (int)((int)((double)this.parent.mc.field_71440_d - (double)(offsetY + this.top + this.height) * scaleH)), (int)((int)((double)this.width * scaleW)), (int)((int)((double)this.height * scaleH)));
        if (this.drawBackground) {
            if (this.parent.mc.field_71441_e != null) {
                this.drawGradientRect(this.left, this.top, this.left + this.width, this.top + this.height, -1059201571, -1059201571);
            } else {
                GlStateManager.func_179140_f();
                GlStateManager.func_179106_n();
                this.parent.mc.field_71446_o.func_110577_a(Gui.field_110325_k);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float scale = 32.0f;
                worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldr.func_181662_b((double)this.left, (double)(this.top + this.height), 0.0).func_187315_a((double)((float)this.left / 32.0f), (double)(((float)(this.top + this.height) + this.scrollDistance) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
                worldr.func_181662_b((double)(this.left + this.width), (double)(this.top + this.height), 0.0).func_187315_a((double)((float)(this.left + this.width) / 32.0f), (double)(((float)(this.top + this.height) + this.scrollDistance) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
                worldr.func_181662_b((double)(this.left + this.width), (double)this.top, 0.0).func_187315_a((double)((float)(this.left + this.width) / 32.0f), (double)(((float)this.top + this.scrollDistance) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
                worldr.func_181662_b((double)this.left, (double)this.top, 0.0).func_187315_a((double)((float)this.left / 32.0f), (double)(((float)this.top + this.scrollDistance) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
                tess.func_78381_a();
            }
        }
        int baseY = this.top + border - (int)this.scrollDistance;
        int extraHeight = this.getContentHeight() + border - this.height;
        int contentHeight = 0;
        if (this.hasHeader) {
            this.drawHeader(entryRight, baseY, tess);
            contentHeight += this.headerHeight;
        }
        for (int slotIdx = 0; slotIdx < listLength; ++slotIdx) {
            int slotTop = baseY + contentHeight;
            int sloltHeight = this.getSlotHeight(slotIdx);
            contentHeight += sloltHeight;
            int slotBuffer = sloltHeight - border;
            if (slotTop > this.top + this.height || slotTop + slotBuffer < this.top) continue;
            if (isHovering && (extraHeight <= 0 || this.mouseX < scrollBarLeft) && this.mouseY >= slotTop && this.mouseY < slotTop + sloltHeight) {
                if (clicked) {
                    this.elementClicked(this.hoveringIndex, this.mouseX - this.left, this.mouseY - slotTop, this.hoveringIndex == this.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L);
                    this.selectedIndex = this.hoveringIndex;
                    this.lastClickTime = System.currentTimeMillis();
                }
                this.hoveringIndex = slotIdx;
            }
            this.drawSlot(slotIdx, entryRight, slotTop, slotBuffer, tess);
        }
        this.cacheContentHeight = contentHeight;
        GlStateManager.func_179097_i();
        worldr.func_178969_c((double)offsetX, (double)offsetY, 0.0);
        if (this.drawScrollbar && extraHeight > 0) {
            int barTop;
            int scrollBarHeight = this.height * this.height / this.getContentHeight();
            if (scrollBarHeight < 32) {
                scrollBarHeight = 32;
            }
            if (scrollBarHeight > this.height - border * 2) {
                scrollBarHeight = this.height - border * 2;
            }
            if ((barTop = (int)this.scrollDistance * (this.height - scrollBarHeight) / extraHeight + this.top) < this.top) {
                barTop = this.top;
            }
            GlStateManager.func_179090_x();
            if (this.drawBackground) {
                worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldr.func_181662_b((double)scrollBarLeft, (double)(this.top + this.height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(221, 221, 221, 255).func_181675_d();
                worldr.func_181662_b((double)scrollBarRight, (double)(this.top + this.height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(221, 221, 221, 255).func_181675_d();
                worldr.func_181662_b((double)scrollBarRight, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(221, 221, 221, 255).func_181675_d();
                worldr.func_181662_b((double)scrollBarLeft, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(221, 221, 221, 255).func_181675_d();
                tess.func_78381_a();
            }
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)(barTop + scrollBarHeight), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)(barTop + scrollBarHeight), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)(barTop + scrollBarHeight - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)(scrollBarRight - 1), (double)(barTop + scrollBarHeight - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)(scrollBarRight - 1), (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        worldr.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)3089);
    }

    protected void drawGradientRect(int left, int top, int right, int bottom, int color1, int color2) {
        GuiUtils.drawGradientRect((int)0, (int)left, (int)top, (int)right, (int)bottom, (int)color1, (int)color2);
    }

    public void cacheContentHeight() {
        int listLenth = this.getSize();
        int height = 0;
        for (int i = 0; i < listLenth; ++i) {
            height += this.getSlotHeight(i);
        }
        this.cacheContentHeight = height;
    }
}

