/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import snownee.kiwi.util.LootDumper;

public class KiwiCommand {
    private static final SimpleCommandExceptionType WRONG_PATTERN_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.kiwi.dumpLoots.wrongPattern", new Object[0]));

    public static void register(CommandDispatcher<CommandSource> dispatcher, boolean integrated) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"kiwi");
        if (integrated) {
            builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"dumpLoots").executes(ctx -> KiwiCommand.dumpLoots((CommandSource)ctx.getSource(), ".+"))).then(Commands.func_197056_a((String)"pattern", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> KiwiCommand.dumpLoots((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"pattern")))));
        }
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"gamemode", (ArgumentType)IntegerArgumentType.integer((int)0, (int)(GameType.values().length - 1))).requires(ctx -> ctx.func_197034_c(2))).executes(ctx -> KiwiCommand.setGameMode((CommandContext<CommandSource>)ctx, Collections.singleton(((CommandSource)ctx.getSource()).func_197035_h()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"gamemode")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> KiwiCommand.setGameMode((CommandContext<CommandSource>)ctx, EntityArgument.func_197090_e((CommandContext)ctx, (String)"target"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"gamemode")))));
        dispatcher.register(builder);
    }

    public static int dumpLoots(CommandSource source, String pattern) throws CommandSyntaxException {
        try {
            Pattern p = Pattern.compile(pattern);
            int r = LootDumper.dump(p, source.func_197028_i().func_71238_n());
            if (r == 0) {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.kiwi.dumpLoots.noTargets", new Object[0]));
            } else {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.kiwi.dumpLoots.success", new Object[]{r}), true);
            }
            return r;
        }
        catch (PatternSyntaxException e) {
            throw WRONG_PATTERN_EXCEPTION.create();
        }
    }

    private static int setGameMode(CommandContext<CommandSource> source, Collection<ServerPlayerEntity> players, int gameType) {
        GameType gameTypeIn = GameType.func_77146_a((int)gameType);
        int i = 0;
        for (ServerPlayerEntity serverplayerentity : players) {
            if (serverplayerentity.field_71134_c.func_73081_b() == gameTypeIn) continue;
            serverplayerentity.func_71033_a(gameTypeIn);
            KiwiCommand.sendGameModeFeedback((CommandSource)source.getSource(), serverplayerentity, gameTypeIn);
            ++i;
        }
        return i;
    }

    private static void sendGameModeFeedback(CommandSource source, ServerPlayerEntity player, GameType gameTypeIn) {
        TranslationTextComponent itextcomponent = new TranslationTextComponent("gameMode." + gameTypeIn.func_77149_b(), new Object[0]);
        if (source.func_197022_f() == player) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.gamemode.success.self", new Object[]{itextcomponent}), true);
        } else {
            if (source.func_197023_e().func_82736_K().func_223586_b(GameRules.field_223611_n)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("gameMode.changed", new Object[]{itextcomponent}));
            }
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.gamemode.success.other", new Object[]{player.func_145748_c_(), itextcomponent}), true);
        }
    }
}

