/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.CrashReportExtender;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.ModContext;
import snownee.kiwi.ModuleInfo;
import snownee.kiwi.crafting.NoContainersShapedRecipe;
import snownee.kiwi.crafting.NoContainersShapelessRecipe;
import snownee.kiwi.crafting.TextureBlockRecipe;

public class KiwiManager {
    public static final Map<ResourceLocation, ModuleInfo> MODULES = Maps.newLinkedHashMap();
    static Map<String, ItemGroup> GROUPS = Maps.newHashMap();
    public static IRecipeSerializer<?> shapedSerializer;
    public static IRecipeSerializer<?> shapelessSerializer;
    public static IRecipeSerializer<?> textureBlockSerializer;

    private KiwiManager() {
    }

    public static void addInstance(ResourceLocation resourceLocation, AbstractModule module, ModContext context) {
        if (MODULES.containsKey(resourceLocation)) {
            Kiwi.logger.error(Kiwi.MARKER, "Found a duplicate module name {}, skipping.", (Object)resourceLocation);
        } else {
            MODULES.put(resourceLocation, new ModuleInfo(resourceLocation, module, context));
        }
    }

    public static void addItemGroup(String modId, String name, ItemGroup group) {
        GROUPS.put(modId + ":" + name, group);
    }

    static void handleRegister(RegistryEvent.Register<?> event) {
        if (event.getRegistry() == ForgeRegistries.RECIPE_SERIALIZERS) {
            IForgeRegistry registry = event.getRegistry();
            shapedSerializer = (IRecipeSerializer)new NoContainersShapedRecipe.Serializer().setRegistryName("kiwi", "shaped_no_containers");
            registry.register((IForgeRegistryEntry)shapedSerializer);
            shapelessSerializer = (IRecipeSerializer)new NoContainersShapelessRecipe.Serializer().setRegistryName("kiwi", "shapeless_no_containers");
            registry.register((IForgeRegistryEntry)shapelessSerializer);
            textureBlockSerializer = (IRecipeSerializer)new TextureBlockRecipe.Serializer().setRegistryName("kiwi", "texture_block");
            registry.register((IForgeRegistryEntry)textureBlockSerializer);
        }
        MODULES.values().forEach(info -> info.handleRegister(event));
        ModLoadingContext.get().setActiveContainer(null, null);
    }

    static {
        CrashReportExtender.registerCrashCallable((String)"Kiwi Modules", () -> "\n" + MODULES.keySet().stream().map(ResourceLocation::toString).sorted(StringUtils::compare).collect(Collectors.joining("\n\t\t", "\t\t", "")));
    }
}

