/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistryEntry;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiManager;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.ModContext;
import snownee.kiwi.NamedEntry;
import snownee.kiwi.RenderLayer;
import snownee.kiwi.item.ModBlockItem;

public class ModuleInfo {
    public final AbstractModule module;
    public final ModContext context;
    public ItemGroup group;
    final RegistryHolder registries = new RegistryHolder();
    final Map<Block, Item.Properties> blockItemBuilders = Maps.newHashMap();
    final Set<Object> noGroups = Sets.newHashSet();
    final Set<Block> noItems = Sets.newHashSet();

    public ModuleInfo(ResourceLocation rl, AbstractModule module, ModContext context) {
        this.module = module;
        this.context = context;
        module.uid = rl;
    }

    public void register(IForgeRegistryEntry<?> entry, ResourceLocation name, @Nullable Field field) {
        this.registries.put(new NamedEntry(name, entry, field));
    }

    public <T extends IForgeRegistryEntry<T>> void handleRegister(RegistryEvent.Register<T> event) {
        this.context.setActiveContainer();
        Class clazz = event.getRegistry().getRegistrySuperType();
        Collection<NamedEntry<NamedEntry>> entries = this.registries.get(clazz);
        BiConsumer<ModuleInfo, IForgeRegistryEntry> decorator = this.module.decorators.getOrDefault(clazz, (a, b) -> {});
        if (clazz == Item.class) {
            this.registries.get(Block.class).forEach(e -> {
                KiwiModule.Group group;
                if (this.noItems.contains(e.entry)) {
                    return;
                }
                Item.Properties builder = this.blockItemBuilders.get(e.entry);
                if (builder == null) {
                    builder = new Item.Properties();
                }
                ModBlockItem item = new ModBlockItem((Block)e.entry, builder);
                if (this.noGroups.contains(e.entry)) {
                    this.noGroups.add((Object)item);
                } else if (e.field != null && (group = e.field.getAnnotation(KiwiModule.Group.class)) != null && !group.value().isEmpty()) {
                    ItemGroup itemGroup = KiwiManager.GROUPS.get(group.value());
                    item.field_77701_a = itemGroup != null ? itemGroup : this.group;
                }
                entries.add(new NamedEntry<ModBlockItem>(e.name, item));
            });
        } else if (clazz == Block.class && FMLEnvironment.dist.isClient()) {
            RenderType solid = RenderType.func_228639_c_();
            HashMap cache = Maps.newHashMap();
            entries.stream().forEach(e -> {
                RenderType type;
                RenderLayer layer;
                Block block = (Block)e.entry;
                if (e.field != null && (layer = e.field.getAnnotation(RenderLayer.class)) != null && (type = layer.value().get()) != solid && type != null) {
                    RenderTypeLookup.setRenderLayer((Block)block, (RenderType)type);
                    return;
                }
                Class<?> klass = block.getClass();
                type = cache.computeIfAbsent(klass, k -> {
                    RenderLayer layer = null;
                    while (k != Block.class) {
                        layer = k.getAnnotation(RenderLayer.class);
                        if (layer != null) {
                            return layer.value().get();
                        }
                        k = k.getSuperclass();
                    }
                    return solid;
                });
                if (type != solid && type != null) {
                    RenderTypeLookup.setRenderLayer((Block)block, (RenderType)type);
                }
            });
        }
        entries.forEach(e -> {
            decorator.accept(this, (IForgeRegistryEntry)e.entry.setRegistryName(e.name));
            event.getRegistry().register(e.entry);
        });
    }

    public void preInit() {
        this.context.setActiveContainer();
        this.module.preInit();
    }

    public void init(FMLCommonSetupEvent event) {
        this.context.setActiveContainer();
        this.module.init(event);
    }

    public void clientInit(FMLClientSetupEvent event) {
        this.context.setActiveContainer();
        this.module.clientInit(event);
    }

    public void serverInit(FMLServerStartingEvent event) {
        this.context.setActiveContainer();
        this.module.serverInit(event);
    }

    public void postInit() {
        this.context.setActiveContainer();
        this.module.postInit();
    }

    static final class RegistryHolder {
        final Multimap<Class, NamedEntry<?>> registries = LinkedListMultimap.create();

        RegistryHolder() {
        }

        <T extends IForgeRegistryEntry<T>> void put(NamedEntry<T> entry) {
            this.registries.put((Object)entry.entry.getRegistryType(), entry);
        }

        <T extends IForgeRegistryEntry<T>> Collection<NamedEntry<T>> get(Class<T> clazz) {
            return this.registries.get(clazz).stream().map(e -> e).collect(Collectors.toList());
        }
    }
}

