/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import snownee.kiwi.client.model.TextureMultipart;
import snownee.kiwi.tile.TextureTile;
import snownee.kiwi.util.NBTHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class TextureModel
implements IDynamicBakedModel {
    public static ModelProperty<Map<String, String>> TEXTURES = new ModelProperty();
    public static Map<IBakedModel, TextureModel> CACHES = Maps.newHashMap();
    private final ModelLoader modelLoader;
    private final IModelTransform variant;
    private final BlockModel originalUnbaked;
    private final IBakedModel originalBaked;
    private TextureOverrideList overrideList;
    private final String particleKey;
    private final Cache<String, IBakedModel> baked = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(500L, TimeUnit.SECONDS).weakKeys().build();

    public static void register(ModelBakeEvent event, Block block, @Nullable BlockState inventoryState) {
        TextureModel.register(event, block, inventoryState, null);
    }

    public static void register(ModelBakeEvent event, Block block, @Nullable BlockState inventoryState, @Nullable String particleKey) {
        block.func_176194_O().func_177619_a().forEach(s -> {
            ModelResourceLocation rl = BlockModelShapes.func_209554_c((BlockState)s);
            TextureModel.register(event, block, rl, s.equals(inventoryState), particleKey);
        });
        CACHES.clear();
    }

    public static void register(ModelBakeEvent event, Block block, ModelResourceLocation rl, boolean inventory, @Nullable String particleKey) {
        TextureModel textureModel = TextureModel.process(event, rl, inventory, particleKey);
        if (inventory && textureModel != null && block != null && block.func_199767_j() != null) {
            rl = new ModelResourceLocation(new ResourceLocation(rl.func_110624_b(), rl.func_110623_a()), "inventory");
            event.getModelRegistry().put(rl, textureModel);
            ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            mesher.func_199311_a(block.func_199767_j(), rl);
        }
    }

    public static void registerInventory(ModelBakeEvent event, IItemProvider item, @Nullable String particleKey) {
        ResourceLocation rl = item.func_199767_j().getRegistryName();
        ModelResourceLocation modelRl = new ModelResourceLocation(new ResourceLocation(rl.func_110624_b(), rl.func_110623_a()), "inventory");
        TextureModel.process(event, modelRl, true, particleKey);
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        mesher.func_199311_a(item.func_199767_j(), modelRl);
    }

    @Nullable
    private static TextureModel process(ModelBakeEvent event, ModelResourceLocation rl, boolean inventory, @Nullable String particleKey) {
        IUnbakedModel unbakedModel = event.getModelLoader().getModelOrLogError((ResourceLocation)rl, "Kiwi failed to replace block model " + rl);
        IBakedModel bakedModel = (IBakedModel)event.getModelRegistry().get(rl);
        if (unbakedModel == null || bakedModel == null) {
            return null;
        }
        TextureModel textureModel = null;
        if (unbakedModel instanceof Multipart && bakedModel instanceof MultipartBakedModel) {
            Multipart originalUnbaked = (Multipart)unbakedModel;
            MultipartBakedModel originalBaked = (MultipartBakedModel)bakedModel;
            List selectors = originalUnbaked.func_188136_a();
            TextureMultipart.Builder builder = new TextureMultipart.Builder();
            for (int i = 0; i < selectors.size(); ++i) {
                Selector selector = (Selector)selectors.get(i);
                VariantList variantList = selector.func_188165_a();
                Pair pair = (Pair)originalBaked.field_188626_f.get(i);
                builder.putModel((Predicate)pair.getLeft(), (IBakedModel)TextureModel.putModel(event, variantList, (IBakedModel)pair.getRight(), false, particleKey));
            }
            event.getModelRegistry().put(rl, builder.build());
        } else if (unbakedModel instanceof VariantList) {
            textureModel = TextureModel.putModel(event, (VariantList)unbakedModel, bakedModel, inventory, particleKey);
        } else if (unbakedModel instanceof BlockModel) {
            textureModel = new TextureModel(event.getModelLoader(), (BlockModel)unbakedModel, bakedModel, (IModelTransform)ModelRotation.X0_Y0, inventory, particleKey);
        }
        if (textureModel != null) {
            event.getModelRegistry().put(rl, textureModel);
        }
        return textureModel;
    }

    @Nullable
    private static TextureModel putModel(ModelBakeEvent event, VariantList variantList, IBakedModel baked, boolean inventory, String particleKey) {
        TextureModel textureModel;
        block2: {
            block1: {
                textureModel = null;
                if (!CACHES.containsKey(baked)) break block1;
                textureModel = CACHES.get(baked);
                if (!inventory) break block2;
                textureModel.setOverrides();
                break block2;
            }
            List variants = variantList.func_188114_a();
            for (Variant variant : variants) {
                IUnbakedModel unbakedModel2 = event.getModelLoader().func_209597_a(variant.func_188046_a());
                if (!(unbakedModel2 instanceof BlockModel)) continue;
                textureModel = new TextureModel(event.getModelLoader(), (BlockModel)unbakedModel2, baked, (IModelTransform)variant, inventory, particleKey);
                CACHES.put(baked, textureModel);
                break;
            }
        }
        return textureModel;
    }

    public TextureModel(ModelLoader modelLoader, BlockModel originalUnbaked, IBakedModel originalBaked, IModelTransform variant, boolean inventory, @Nullable String particleKey) {
        this.modelLoader = modelLoader;
        this.originalUnbaked = originalUnbaked;
        this.originalBaked = originalBaked;
        this.variant = variant;
        this.particleKey = particleKey;
        this.overrideList = inventory ? new TextureOverrideList(this) : null;
    }

    public void setOverrides() {
        if (this.overrideList == null) {
            this.overrideList = new TextureOverrideList(this);
        }
    }

    public boolean func_177555_b() {
        return this.originalBaked.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.originalBaked.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite getParticleTexture(IModelData data) {
        if (this.particleKey != null && data.getData(TEXTURES) != null && ((Map)data.getData(TEXTURES)).containsKey(this.particleKey)) {
            Material material = ModelLoaderRegistry.blockMaterial((String)((String)((Map)data.getData(TEXTURES)).get(this.particleKey)));
            TextureAtlasSprite particle = (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(material);
            if (particle.getClass() != MissingTextureSprite.class) {
                return particle;
            }
        }
        return this.func_177554_e();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.originalBaked.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList == null ? this.originalBaked.func_188617_f() : this.overrideList;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.originalBaked.func_177552_f();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        Map overrides = (Map)extraData.getData(TEXTURES);
        IBakedModel model = this.getModel(overrides);
        return model.func_200117_a(state, side, rand);
    }

    private IBakedModel getModel(Map<String, String> overrides) {
        if (overrides == null) {
            return this.originalBaked;
        }
        HashMap textures = Maps.newHashMap();
        TextureModel.resolveTextures(textures, this.originalUnbaked, false);
        overrides.forEach((k, v) -> {
            if (!v.isEmpty()) {
                textures.put(k, Either.left((Object)ModelLoaderRegistry.blockMaterial((String)v)));
            }
        });
        String key = TextureModel.generateKey(overrides);
        IBakedModel model = null;
        ResourceLocation loaderId = new ResourceLocation("minecraft:elements");
        try {
            model = (IBakedModel)this.baked.get((Object)key, () -> {
                BlockModel unbaked = new BlockModel(this.originalUnbaked.getParentLocation(), this.originalUnbaked.func_178298_a(), textures, this.originalUnbaked.func_178309_b(), this.originalUnbaked.func_178311_c(), this.originalUnbaked.func_181682_g(), (List)Lists.newArrayList((Iterable)this.originalUnbaked.func_187966_f()));
                return unbaked.func_225613_a_((ModelBakery)this.modelLoader, ModelLoader.defaultTextureGetter(), this.variant, loaderId);
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return this.originalBaked;
        }
        return model;
    }

    private static void resolveTextures(Map<String, Either<Material, String>> textures2, BlockModel model, boolean sub) {
        if (model.field_178315_d != null) {
            TextureModel.resolveTextures(textures2, model.field_178315_d, true);
        }
        textures2.putAll(model.field_178318_c);
        if (!sub) {
            HashSet hashes = Sets.newHashSet();
            textures2.forEach((k, v) -> v.ifRight(s -> hashes.add(k)));
            do {
                hashes.removeIf(k -> {
                    Either v = (Either)textures2.get(k);
                    if (v == null) {
                        textures2.put((String)k, (Either<Material, String>)Either.left((Object)ModelLoaderRegistry.blockMaterial((ResourceLocation)MissingTextureSprite.func_195675_b())));
                        return true;
                    }
                    String hash = (String)v.right().get();
                    Either to = (Either)textures2.get(hash);
                    if (to == null || hash.equals(k) || to.right().isPresent() && ((String)to.right().get()).equals(k)) {
                        textures2.put((String)k, (Either<Material, String>)Either.left((Object)ModelLoaderRegistry.blockMaterial((ResourceLocation)MissingTextureSprite.func_195675_b())));
                        return true;
                    }
                    textures2.put((String)k, (Either<Material, String>)to);
                    return to.left().isPresent();
                });
            } while (!hashes.isEmpty());
        }
    }

    public IModelData getModelData(ILightReader world, BlockPos pos, BlockState state, IModelData tileData) {
        return tileData;
    }

    private static String generateKey(Map<String, String> textures) {
        if (textures == null) {
            return "";
        }
        return StringUtils.join(textures.entrySet(), (char)',');
    }

    public static class TextureOverrideList
    extends ItemOverrideList {
        private final TextureModel baked;
        private final Cache<ItemStack, IBakedModel> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(300L, TimeUnit.SECONDS).weakKeys().build();

        public TextureOverrideList(TextureModel model) {
            this.baked = model;
        }

        public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, World worldIn, LivingEntity entityIn) {
            if (model instanceof TextureModel) {
                try {
                    model = (IBakedModel)this.cache.get((Object)stack, () -> {
                        CompoundNBT data = NBTHelper.of(stack).getTag("BlockEntityTag.Textures");
                        if (data == null) {
                            return this.baked.originalBaked;
                        }
                        Set keySet = data.func_150296_c();
                        HashMap overrides = Maps.newHashMapWithExpectedSize((int)keySet.size());
                        keySet.forEach(k -> overrides.put(k, ""));
                        TextureTile.readTextures(overrides, data);
                        return this.baked.getModel(overrides);
                    });
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return model;
        }

        public ImmutableList<ItemOverride> getOverrides() {
            return ImmutableList.of();
        }
    }
}

