/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiConfig;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.contributor.IRewardProvider;
import snownee.kiwi.contributor.client.RewardLayer;
import snownee.kiwi.contributor.impl.KiwiRewardProvider;
import snownee.kiwi.contributor.network.CSetEffectPacket;
import snownee.kiwi.contributor.network.SSyncEffectPacket;
import snownee.kiwi.network.NetworkChannel;

@KiwiModule(name="contributors")
@KiwiModule.Subscriber
public class Contributors
extends AbstractModule {
    public static final Map<String, IRewardProvider> REWARD_PROVIDERS = Maps.newConcurrentMap();
    public static final Map<String, ResourceLocation> PLAYER_EFFECTS = Maps.newConcurrentMap();

    @Override
    protected void preInit() {
        NetworkChannel.register(CSetEffectPacket.class, new CSetEffectPacket.Handler());
        NetworkChannel.register(SSyncEffectPacket.class, new SSyncEffectPacket.Handler());
    }

    @Override
    protected void init(FMLCommonSetupEvent event) {
        Contributors.registerRewardProvider(new KiwiRewardProvider());
    }

    public static boolean isContributor(String author, String playerName) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), IRewardProvider.Empty.INSTANCE).isContributor(playerName);
    }

    public static boolean isContributor(String author, String playerName, String tier) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), IRewardProvider.Empty.INSTANCE).isContributor(playerName, tier);
    }

    public static boolean isContributor(String author, PlayerEntity player) {
        return Contributors.isContributor(author, player.func_146103_bH().getName());
    }

    public static boolean isContributor(String author, PlayerEntity player, String tier) {
        return Contributors.isContributor(author, player.func_146103_bH().getName(), tier);
    }

    public static Set<ResourceLocation> getRewards(String playerName) {
        return REWARD_PROVIDERS.values().stream().flatMap(rp -> rp.getRewards(playerName).stream().map(s -> new ResourceLocation(rp.getAuthor().toLowerCase(Locale.ENGLISH), s))).collect(Collectors.toSet());
    }

    public static void registerRewardProvider(IRewardProvider rewardProvider) {
        REWARD_PROVIDERS.put(rewardProvider.getAuthor().toLowerCase(Locale.ENGLISH), rewardProvider);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        new SSyncEffectPacket(PLAYER_EFFECTS).send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        Contributors.changeEffect();
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PLAYER_EFFECTS.remove(event.getPlayer().func_146103_bH().getName());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        PLAYER_EFFECTS.clear();
        RewardLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidateAll());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(FMLClientSetupEvent event) {
        Minecraft.func_71410_x().func_175598_ae().getSkinMap().values().forEach(renderer -> {
            RewardLayer layer = new RewardLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderer);
            RewardLayer.ALL_LAYERS.add(layer);
            renderer.func_177094_a((LayerRenderer)layer);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void changeEffect() {
        if (!Contributors.canPlayerUseEffect(Contributors.getUserName(), KiwiConfig.contributorEffect)) {
            return;
        }
        new CSetEffectPacket(KiwiConfig.contributorEffect).send();
        if (KiwiConfig.contributorEffect == null) {
            PLAYER_EFFECTS.remove(Contributors.getUserName());
        } else {
            RewardLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidate((Object)Contributors.getUserName()));
            PLAYER_EFFECTS.put(Contributors.getUserName(), KiwiConfig.contributorEffect);
            Kiwi.logger.info("Enabled contributor effect: {}", (Object)KiwiConfig.contributorEffect);
        }
        RewardLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidate((Object)Contributors.getUserName()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void changeEffect(Map<String, ResourceLocation> changes) {
        changes.forEach((k, v) -> {
            if (v == null) {
                PLAYER_EFFECTS.remove(k);
            } else {
                PLAYER_EFFECTS.put((String)k, (ResourceLocation)v);
            }
        });
        RewardLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidateAll(changes.keySet()));
    }

    public static void changeEffect(ServerPlayerEntity player, ResourceLocation effect) {
        String playerName = player.func_146103_bH().getName();
        if (!Contributors.canPlayerUseEffect(playerName, effect)) {
            return;
        }
        if (effect == null) {
            PLAYER_EFFECTS.remove(playerName);
        } else {
            PLAYER_EFFECTS.put(playerName, effect);
        }
        new SSyncEffectPacket((Map<String, ResourceLocation>)ImmutableMap.of((Object)playerName, (Object)effect)).sendExcept(player);
    }

    public static boolean isValidEffect(ResourceLocation id) {
        return REWARD_PROVIDERS.containsKey(id.func_110624_b()) && REWARD_PROVIDERS.get(id.func_110624_b()).hasRenderer(id.func_110623_a());
    }

    public static boolean canPlayerUseEffect(String playerName, ResourceLocation effect) {
        if (effect == null) {
            return true;
        }
        if (!Contributors.isContributor(effect.func_110624_b(), playerName, effect.func_110623_a())) {
            return false;
        }
        return Contributors.isValidEffect(effect);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getUserName() {
        return Minecraft.func_71410_x().func_110432_I().func_111285_a();
    }
}

