/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.Kiwi;
import snownee.kiwi.contributor.Contributors;

@OnlyIn(value=Dist.CLIENT)
public class RewardLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public static final Collection<RewardLayer> ALL_LAYERS = Lists.newLinkedList();
    private final Cache<ResourceLocation, LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>> rewardId2renderer;
    private final Cache<String, LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>> player2renderer;

    public RewardLayer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
        if (((Object)((Object)this)).getClass() == RewardLayer.class) {
            this.rewardId2renderer = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
            this.player2renderer = CacheBuilder.newBuilder().build();
        } else {
            this.rewardId2renderer = null;
            this.player2renderer = null;
        }
    }

    public void func_225628_a_(MatrixStack matrix, IRenderTypeBuffer buffer, int p_225628_3_, AbstractClientPlayerEntity entityIn, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        if (this.player2renderer == null || this.rewardId2renderer == null) {
            return;
        }
        try {
            ResourceLocation id;
            LayerRenderer renderer = (LayerRenderer)this.player2renderer.getIfPresent((Object)entityIn.func_146103_bH().getName());
            if (renderer == null && (id = Contributors.PLAYER_EFFECTS.get(entityIn.func_146103_bH().getName())) != null) {
                renderer = (LayerRenderer)this.rewardId2renderer.get((Object)id, () -> Contributors.REWARD_PROVIDERS.get(id.func_110624_b().toLowerCase(Locale.ENGLISH)).createRenderer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)this.field_215335_a, id.func_110623_a()));
                this.player2renderer.put((Object)entityIn.func_146103_bH().getName(), (Object)renderer);
            }
            if (renderer != null) {
                renderer.func_225628_a_(matrix, buffer, p_225628_3_, (Entity)entityIn, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_);
            }
        }
        catch (ExecutionException e) {
            Kiwi.logger.catching((Throwable)e);
        }
    }

    public Cache<String, LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>> getCache() {
        return this.player2renderer;
    }
}

