/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import snownee.kiwi.KiwiManager;
import snownee.kiwi.crafting.DynamicShapedRecipe;
import snownee.kiwi.crafting.FullBlockIngredient;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;

public class TextureBlockRecipe
extends DynamicShapedRecipe {
    private final List<String> textureKeys;
    private final List<String> marks;
    private int keyCount = -1;

    public TextureBlockRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> ingredients, ItemStack recipeOutputIn, List<String> textureKeys, List<String> marks) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, ingredients, recipeOutputIn);
        this.textureKeys = textureKeys;
        this.marks = marks;
    }

    @Override
    protected boolean checkMatch(CraftingInventory inv, int startX, int startY) {
        return this.checkMatchInternal(inv, startX, startY) != null;
    }

    private Map<String, ItemStack> checkMatchInternal(CraftingInventory inv, int startX, int startY) {
        HashMap result = null;
        int i = 0;
        for (int y = startY; y < startY + this.getRecipeHeight(); ++y) {
            for (int x = startX; x < startX + this.getRecipeWidth(); ++x) {
                String key = this.textureKeys.get(i);
                if (key != null) {
                    if (result == null) {
                        if (this.keyCount < 0) {
                            HashSet set = Sets.newHashSet(this.textureKeys);
                            set.remove(null);
                            this.keyCount = set.size();
                        }
                        result = Maps.newHashMapWithExpectedSize((int)this.keyCount);
                    }
                    ItemStack slotStack = inv.func_70301_a(x + y * inv.func_174922_i());
                    Ingredient ingredient = (Ingredient)this.func_192400_c().get(x - startX + (y - startY) * this.getRecipeWidth());
                    if (!(ingredient instanceof FullBlockIngredient) && !FullBlockIngredient.isTextureBlock(slotStack)) {
                        return null;
                    }
                    ItemStack stack = result.getOrDefault(key, ItemStack.field_190927_a);
                    if (stack.func_190926_b()) {
                        result.put(key, slotStack);
                    } else if (!stack.func_77969_a(slotStack)) {
                        return null;
                    }
                }
                if (!this.matches(inv, x, y, x - startX, y - startY)) {
                    return null;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public ItemStack getCraftingResult(CraftingInventory inv) {
        int[] pos = this.getMatchPos(inv);
        if (pos == null) {
            return ItemStack.field_190927_a;
        }
        Map<String, ItemStack> result = this.checkMatchInternal(inv, pos[0], pos[1]);
        if (result == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.func_77571_b().func_77946_l();
        NBTHelper data = NBTHelper.of(stack.func_190925_c("BlockEntityTag"));
        for (Map.Entry<String, ItemStack> e : result.entrySet()) {
            Item item = e.getValue().func_77973_b();
            if (item instanceof BlockItem) {
                BlockState state = ((BlockItem)item).func_179223_d().func_176223_P();
                for (String k : e.getKey().split(",")) {
                    data.setString("Textures." + k, NBTUtil.func_190009_a((BlockState)state).toString());
                    if (!this.marks.contains(k)) continue;
                    data.setString("Items." + k, Util.trimRL(item.getRegistryName()));
                }
                continue;
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return KiwiManager.textureBlockSerializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TextureBlockRecipe> {
        public TextureBlockRecipe read(ResourceLocation recipeId, JsonObject json) {
            List<Object> marks;
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map ingredientMap = ShapedRecipe.func_192408_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.func_194134_a((String[])ShapedRecipe.func_192407_a((JsonArray)JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList nonnulllist = ShapedRecipe.func_192402_a((String[])pattern, (Map)ingredientMap, (int)width, (int)height);
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            HashMap texMap = Maps.newHashMap();
            for (Map.Entry entry : JSONUtils.func_152754_s((JsonObject)json, (String)"texture").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey()) || ",".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is a reserved symbol.");
                }
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    List keys = Lists.newArrayList((Iterable)((JsonElement)entry.getValue()).getAsJsonArray()).stream().map(JsonElement::getAsString).collect(Collectors.toList());
                    texMap.put(entry.getKey(), StringUtils.join(keys, (char)','));
                    continue;
                }
                texMap.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            ArrayList keys = Lists.newArrayListWithExpectedSize((int)(width * height));
            HashSet set = Sets.newHashSet(texMap.keySet());
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[i].length(); ++j) {
                    String s = pattern[i].substring(j, j + 1);
                    if (texMap.containsKey(s)) {
                        keys.add(texMap.get(s));
                        set.remove(s);
                        continue;
                    }
                    keys.add(null);
                }
            }
            if (!set.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
            }
            if (JSONUtils.func_151202_d((JsonObject)json, (String)"mark")) {
                JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)"mark");
                marks = Lists.newArrayListWithCapacity((int)array.size());
                array.forEach(e -> marks.add(e.getAsString()));
            } else {
                String mark = JSONUtils.func_151219_a((JsonObject)json, (String)"mark", (String)"");
                marks = Collections.singletonList(mark);
            }
            return new TextureBlockRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)nonnulllist, itemstack, keys, marks);
        }

        public TextureBlockRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int width = buffer.func_150792_a();
            int height = buffer.func_150792_a();
            String s = buffer.func_218666_n();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            ArrayList keys = Lists.newArrayListWithExpectedSize((int)(width * height));
            for (int i = 0; i < width * height; ++i) {
                String k = buffer.func_218666_n();
                keys.add(k.isEmpty() ? null : k);
            }
            ImmutableList marks = ImmutableList.copyOf((Object[])buffer.func_218666_n().split(","));
            return new TextureBlockRecipe(recipeId, s, width, height, (NonNullList<Ingredient>)nonnulllist, itemstack, keys, (List<String>)marks);
        }

        public void write(PacketBuffer buffer, TextureBlockRecipe recipe) {
            buffer.func_150787_b(recipe.getRecipeWidth());
            buffer.func_150787_b(recipe.getRecipeHeight());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
            for (int i = 0; i < recipe.getRecipeWidth() * recipe.getRecipeHeight(); ++i) {
                String k = (String)recipe.textureKeys.get(i);
                buffer.func_180714_a(k == null ? "" : k);
            }
            buffer.func_211400_a(StringUtils.join((Object[])new List[]{recipe.marks}), 44);
        }
    }
}

