/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.schedule.impl;

import com.google.common.base.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import snownee.kiwi.schedule.Task;
import snownee.kiwi.schedule.impl.GlobalTicker;

public class SimpleGlobalTask
extends Task<GlobalTicker>
implements INBTSerializable<CompoundNBT> {
    protected int tick = 0;
    protected LogicalSide side;
    protected TickEvent.Phase phase;
    protected Function<Integer, Boolean> function;

    public SimpleGlobalTask() {
    }

    public SimpleGlobalTask(LogicalSide side, TickEvent.Phase phase, Function<Integer, Boolean> function) {
        this.side = side;
        this.phase = phase;
        this.function = function;
    }

    @Override
    public boolean tick(GlobalTicker ticker) {
        return (Boolean)this.function.apply((Object)(++this.tick));
    }

    @Override
    public GlobalTicker ticker() {
        return GlobalTicker.get(this.side, this.phase);
    }

    @Override
    public boolean shouldSave() {
        return this.getClass() != SimpleGlobalTask.class;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("tick", this.tick);
        data.func_74757_a("client", this.side == LogicalSide.CLIENT);
        data.func_74757_a("start", this.phase == TickEvent.Phase.START);
        return data;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.tick = nbt.func_74762_e("tick");
        this.side = nbt.func_74767_n("client") ? LogicalSide.CLIENT : LogicalSide.SERVER;
        this.phase = nbt.func_74767_n("start") ? TickEvent.Phase.START : TickEvent.Phase.END;
    }
}

