/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.base.MoreObjects;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class DimBlockPos
extends BlockPos {
    private int dim;

    public DimBlockPos(int dim, int x, int y, int z) {
        super(x, y, z);
        this.dim = dim;
    }

    public DimBlockPos(int dim, double x, double y, double z) {
        super(x, y, z);
        this.dim = dim;
    }

    public DimBlockPos(Entity source) {
        super(source);
        this.dim = source.field_70170_p.func_175624_G().func_82747_f();
    }

    public DimBlockPos(int dim, Vec3d vec) {
        super(vec);
        this.dim = dim;
    }

    public DimBlockPos(int dim, IPosition source) {
        super(source);
        this.dim = dim;
    }

    public DimBlockPos(int dim, Vec3i source) {
        super(source);
        this.dim = dim;
    }

    public DimBlockPos(World world, Vec3i source) {
        super(source);
        this.dim = world.func_175624_G().func_82747_f();
    }

    public int getDimension() {
        return this.dim;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof DimBlockPos)) {
            return false;
        }
        return this.getDimension() == ((DimBlockPos)((Object)that)).getDimension() && super.equals(that);
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.getDimension() - 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("dim", this.dim).add("x", this.func_177958_n()).add("y", this.func_177956_o()).add("z", this.func_177952_p()).toString();
    }

    public static CompoundNBT write(DimBlockPos pos) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74768_a("Dim", pos.getDimension());
        compoundnbt.func_74768_a("X", pos.func_177958_n());
        compoundnbt.func_74768_a("Y", pos.func_177956_o());
        compoundnbt.func_74768_a("Z", pos.func_177952_p());
        return compoundnbt;
    }

    public static DimBlockPos read(CompoundNBT tag) {
        return new DimBlockPos(tag.func_74762_e("Dim"), tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
    }
}

