/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.util.NBTHelper;

public final class Util {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");
    public static final MessageFormat MESSAGE_FORMAT = new MessageFormat("{0,number,#.#}");

    private Util() {
    }

    public static String color(int color) {
        return String.format("\u00a7x%06x", color & 0xFFFFFF);
    }

    public static String formatComma(long number) {
        return DECIMAL_FORMAT.format(number);
    }

    public static String formatCompact(long number) {
        int unit = 1000;
        if (number < (long)unit) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(number) / Math.log(unit));
        if (exp - 1 >= 0 && exp - 1 < 6) {
            char pre = "kMGTPE".charAt(exp - 1);
            return MESSAGE_FORMAT.format(new Double[]{(double)number / Math.pow(unit, exp)}) + pre;
        }
        return Long.toString(number);
    }

    public static String trimRL(ResourceLocation rl) {
        return rl.func_110624_b().equals("minecraft") ? rl.func_110623_a() : rl.toString();
    }

    public static String trimRL(String rl) {
        if (rl.startsWith("minecraft:")) {
            return rl.substring("minecraft:".length());
        }
        return rl;
    }

    @Nullable
    public static ResourceLocation RL(@Nullable String string) {
        try {
            return ResourceLocation.func_208304_a((String)string);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static ResourceLocation RL(@Nullable String string, String defaultNamespace) {
        if (string != null && !string.contains(":")) {
            string = defaultNamespace + ":" + string;
        }
        return Util.RL(string);
    }

    public static String getTextureItem(ItemStack stack, String mark) {
        Item item;
        NBTHelper data = NBTHelper.of(stack);
        ResourceLocation rl = Util.RL(data.getString("BlockEntityTag.Items." + mark));
        if (rl != null && (item = (Item)ForgeRegistries.ITEMS.getValue(rl)) != null) {
            return item.func_77658_a();
        }
        return "";
    }
}

