/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.Kiwi;
import snownee.kiwi.contributor.IRewardProvider;
import snownee.kiwi.contributor.client.RewardLayer;

public class JsonRewardProvider
implements IRewardProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final String author;
    private ImmutableSetMultimap<String, String> contributors = ImmutableSetMultimap.of();

    public JsonRewardProvider(String author, String url) {
        this.author = author;
        Thread thread = new Thread(() -> {
            int tried = 0;
            while (++tried <= 3 && !this.load(url)) {
            }
        }, String.format("[Kiwi > %s] Loading Contributors", author));
        thread.setDaemon(true);
        thread.start();
    }

    public boolean load(String url) {
        try {
            InputStreamReader reader = new InputStreamReader(new URL(url).openStream());
            Map map = (Map)GSON.fromJson((Reader)reader, Map.class);
            Collection<String> superUsers = map.containsKey("*") ? (Collection)map.get("*") : Collections.singleton(this.getAuthor());
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            map.forEach((reward, users) -> {
                if (reward.equals("*")) {
                    return;
                }
                superUsers.forEach(user -> builder.put(user, reward));
                users.forEach(user -> builder.put(user, reward));
            });
            this.contributors = builder.build();
            Kiwi.logger.debug("Successfully loaded {} contributors.", (Object)this.contributors.keySet().size());
            return true;
        }
        catch (Exception e) {
            Kiwi.logger.catching((Throwable)e);
            return e instanceof UnknownHostException;
        }
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public boolean isContributor(String playerName) {
        return this.contributors.containsKey((Object)playerName);
    }

    @Override
    public boolean isContributor(String playerName, String tier) {
        return this.contributors.containsKey((Object)playerName) && this.contributors.get((Object)playerName).contains((Object)tier);
    }

    @Override
    public Set<String> getRewards(String playerName) {
        return this.contributors.containsKey((Object)playerName) ? this.contributors.get((Object)playerName) : Collections.EMPTY_SET;
    }

    @Override
    public boolean hasRenderer(String tier) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RewardLayer createRenderer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRenderer, String tier) {
        return null;
    }
}

