/*
 * Decompiled with CFR 0.152.
 */
package third_party.com.facebook.yoga;

import third_party.com.facebook.yoga.YogaUnit;

public class YogaValue {
    public static final YogaValue UNDEFINED = new YogaValue(Float.NaN, YogaUnit.Undefined);
    public static final YogaValue ZERO = new YogaValue(0.0f, YogaUnit.Point);
    public static final YogaValue AUTO = new YogaValue(Float.NaN, YogaUnit.Auto);
    public final float Value;
    public final YogaUnit Unit;

    public YogaValue(float Value, YogaUnit Unit) {
        this.Value = Value;
        this.Unit = Unit;
    }

    public boolean equals(Object other) {
        if (other instanceof YogaValue) {
            YogaValue otherValue = (YogaValue)other;
            if (this.Unit == otherValue.Unit) {
                return this.Unit == YogaUnit.Undefined || this.Unit == YogaUnit.Auto || Float.compare(this.Value, otherValue.Value) == 0;
            }
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.Value) + this.Unit.ordinal();
    }

    public String toString() {
        switch (this.Unit) {
            case Undefined: {
                return "undefined";
            }
            case Point: {
                return Float.toString(this.Value);
            }
            case Percent: {
                return this.Value + "%";
            }
            case Auto: {
                return "auto";
            }
        }
        throw new IllegalStateException();
    }

    public static YogaValue Parse(String s) {
        if (s == null) {
            return null;
        }
        if ("undefined".equals(s)) {
            return UNDEFINED;
        }
        if ("auto".equals(s)) {
            return AUTO;
        }
        if (s.endsWith("%")) {
            return new YogaValue(Float.parseFloat(s.substring(0, s.length() - 1)), YogaUnit.Percent);
        }
        return new YogaValue(Float.parseFloat(s), YogaUnit.Point);
    }

    public float Resolve(float ownerSize) {
        switch (this.Unit) {
            default: {
                return Float.NaN;
            }
            case Point: {
                return this.Value;
            }
            case Percent: 
        }
        return this.Value * ownerSize * 0.01f;
    }

    public static YogaValue Percent(float value) {
        return new YogaValue(value, YogaUnit.Percent);
    }

    public static YogaValue Pt(float value) {
        return new YogaValue(value, YogaUnit.Point);
    }
}

