/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.handler;

import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.gui.GuiRadialMenu;
import dmillerw.menu.handler.ConfigHandler;
import dmillerw.menu.helper.KeyReflectionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyboardHandler {
    public static final KeyboardHandler INSTANCE = new KeyboardHandler();
    private static final KeyBinding WHEEL = new KeyBinding("key.open_menu", 19, "key.categories.misc");
    private static boolean lastWheelState = false;
    private final List<KeyBinding> firedKeys = new ArrayList<KeyBinding>();
    private final List<KeyBinding> toggledKeys = new ArrayList<KeyBinding>();
    private boolean ignoreNextTick = false;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        ClientRegistry.registerKeyBinding((KeyBinding)WHEEL);
    }

    private KeyboardHandler() {
    }

    public void fireKey(KeyBinding key) {
        this.firedKeys.add(key);
        KeyReflectionHelper.pressKey(key);
        KeyReflectionHelper.increasePressTime(key);
        boolean old = Minecraft.func_71410_x().field_71415_G;
        Minecraft.func_71410_x().field_71415_G = true;
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.KeyInputEvent());
        Minecraft.func_71410_x().field_71415_G = old;
        this.ignoreNextTick = true;
    }

    public void toggleKey(KeyBinding key) {
        if (!this.toggledKeys.contains(key)) {
            this.toggledKeys.add(key);
            KeyReflectionHelper.pressKey(key);
            KeyReflectionHelper.increasePressTime(key);
        } else {
            this.toggledKeys.remove(key);
            KeyReflectionHelper.unpressKey(key);
        }
        boolean old = Minecraft.func_71410_x().field_71415_G;
        Minecraft.func_71410_x().field_71415_G = true;
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.KeyInputEvent());
        Minecraft.func_71410_x().field_71415_G = old;
        this.ignoreNextTick = true;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        KeyBinding keyBinding;
        boolean wheelKeyPressed;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        boolean bl = wheelKeyPressed = WHEEL.func_151463_i() >= 0 ? Keyboard.isKeyDown((int)WHEEL.func_151463_i()) : Mouse.isButtonDown((int)(WHEEL.func_151463_i() + 100));
        if (wheelKeyPressed != lastWheelState) {
            if (ConfigHandler.toggle) {
                if (wheelKeyPressed) {
                    if (GuiRadialMenu.active) {
                        if (ConfigHandler.releaseToSelect) {
                            GuiRadialMenu.INSTANCE.func_73864_a(Mouse.getX(), Mouse.getY(), 0);
                        }
                        GuiRadialMenu.deactivate();
                    } else if (mc.field_71462_r == null || mc.field_71462_r instanceof GuiRadialMenu) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        GuiRadialMenu.activate();
                    }
                }
            } else if (wheelKeyPressed != GuiRadialMenu.active) {
                if (wheelKeyPressed) {
                    if (mc.field_71462_r == null || mc.field_71462_r instanceof GuiRadialMenu) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        GuiRadialMenu.activate();
                    }
                } else {
                    if (ConfigHandler.releaseToSelect) {
                        GuiRadialMenu.INSTANCE.func_73864_a(Mouse.getX(), Mouse.getY(), 0);
                    }
                    GuiRadialMenu.deactivate();
                }
            }
        }
        lastWheelState = wheelKeyPressed;
        if (this.ignoreNextTick) {
            this.ignoreNextTick = false;
            return;
        }
        Iterator<KeyBinding> iterator = this.firedKeys.iterator();
        while (iterator.hasNext()) {
            keyBinding = iterator.next();
            KeyReflectionHelper.unpressKey(keyBinding);
            iterator.remove();
        }
        iterator = this.toggledKeys.iterator();
        while (iterator.hasNext()) {
            keyBinding = iterator.next();
            if (!(keyBinding.func_151463_i() >= 0 ? Keyboard.isKeyDown((int)keyBinding.func_151463_i()) : Mouse.isButtonDown((int)(keyBinding.func_151463_i() + 100)))) continue;
            iterator.remove();
        }
        for (KeyBinding keyBinding2 : this.toggledKeys) {
            KeyReflectionHelper.increasePressTime(keyBinding2);
        }
    }
}

