/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.handler;

import dmillerw.menu.data.menu.MenuItem;
import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.data.session.ActionSessionData;
import dmillerw.menu.gui.CompatibleScaledResolution;
import dmillerw.menu.gui.GuiRadialMenu;
import dmillerw.menu.handler.ConfigHandler;
import dmillerw.menu.helper.AngleHelper;
import dmillerw.menu.helper.ItemRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientTickHandler {
    public static final double ANGLE_PER_ITEM = 36.0;
    private static final int ITEM_RENDER_ANGLE_OFFSET = -2;
    private static final double OUTER_RADIUS = 80.0;
    private static final double INNER_RADIUS = 60.0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            RadialMenu.tickTimer();
            Minecraft mc = Minecraft.func_71410_x();
            if ((mc.field_71441_e == null || mc.func_147113_T()) && GuiRadialMenu.active) {
                GuiRadialMenu.deactivate();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null && !mc.field_71474_y.field_74319_N && !mc.func_147113_T() && GuiRadialMenu.active) {
                CompatibleScaledResolution resolution = new CompatibleScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                ClientTickHandler.renderGui(resolution);
                ClientTickHandler.renderItems(resolution);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && GuiRadialMenu.active) {
            event.setCanceled(true);
        }
        if (!(event instanceof RenderGameOverlayEvent.Post) || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !mc.field_71474_y.field_74319_N && !mc.func_147113_T() && GuiRadialMenu.active) {
            ClientTickHandler.renderText(event.getResolution());
        }
    }

    private static void renderGui(CompatibleScaledResolution resolution) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 270.0;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            float alpha;
            float b;
            float g;
            float r;
            MenuItem item = RadialMenu.getActiveArray()[i];
            boolean disabled = item != null && !ActionSessionData.AVAILABLE_ACTIONS.contains((Object)item.clickAction.getClickAction());
            double currAngle = 36.0 * (double)i;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean mouseIn = mouseAngle > currAngle && mouseAngle < nextAngle;
            currAngle = Math.toRadians(currAngle);
            nextAngle = Math.toRadians(nextAngle);
            double innerRadius = (60.0 - (double)RadialMenu.animationTimer - (double)(mouseIn ? 2 : 0)) / 100.0 * (double)(257.0f / (float)resolution.getScaledHeight());
            double outerRadius = (80.0 - (double)RadialMenu.animationTimer + (double)(mouseIn ? 2 : 0)) / 100.0 * (double)(257.0f / (float)resolution.getScaledHeight());
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            if (mouseIn) {
                if (disabled) {
                    r = 0.78431374f;
                    g = 0.78431374f;
                    b = 0.78431374f;
                    alpha = (float)ConfigHandler.selectAlpha / 255.0f;
                } else {
                    r = (float)ConfigHandler.selectRed / 255.0f;
                    g = (float)ConfigHandler.selectGreen / 255.0f;
                    b = (float)ConfigHandler.selectBlue / 255.0f;
                    alpha = (float)ConfigHandler.selectAlpha / 255.0f;
                }
            } else {
                r = (float)ConfigHandler.menuRed / 255.0f;
                g = (float)ConfigHandler.menuGreen / 255.0f;
                b = (float)ConfigHandler.menuBlue / 255.0f;
                alpha = (float)ConfigHandler.menuAlpha / 255.0f;
            }
            bufferBuilder.func_181662_b(Math.cos(currAngle) * resolution.getScaledHeight_double() / resolution.getScaledWidth_double() * innerRadius, Math.sin(currAngle) * innerRadius, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            bufferBuilder.func_181662_b(Math.cos(currAngle) * resolution.getScaledHeight_double() / resolution.getScaledWidth_double() * outerRadius, Math.sin(currAngle) * outerRadius, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            bufferBuilder.func_181662_b(Math.cos(nextAngle) * resolution.getScaledHeight_double() / resolution.getScaledWidth_double() * outerRadius, Math.sin(nextAngle) * outerRadius, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            bufferBuilder.func_181662_b(Math.cos(nextAngle) * resolution.getScaledHeight_double() / resolution.getScaledWidth_double() * innerRadius, Math.sin(nextAngle) * innerRadius, 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static void renderItems(CompatibleScaledResolution resolution) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(resolution.getScaledWidth_double() / 2.0), (double)(resolution.getScaledHeight_double() / 2.0), (double)0.0);
        RenderHelper.func_74520_c();
        for (int i = 0; i < 10; ++i) {
            MenuItem item = RadialMenu.getActiveArray()[i];
            Item menuButton = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(ConfigHandler.menuButtonIcon));
            ItemStack stack = item != null && !item.icon.func_190926_b() ? item.icon : (menuButton == null ? ItemStack.field_190927_a : new ItemStack(menuButton));
            double angle = 36.0 * (double)i + -72.0 - 18.0;
            double drawOffset = 1.5;
            double drawX = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double drawY = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double length = Math.sqrt(drawX * drawX + drawY * drawY);
            drawX = length * Math.cos(StrictMath.toRadians(angle));
            drawY = length * Math.sin(StrictMath.toRadians(angle));
            ItemRenderHelper.renderItem((float)drawX, (float)drawY, stack);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    private static void renderText(ScaledResolution resolution) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 18.0;
        mouseAngle = 360.0 - mouseAngle;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            String string;
            boolean mouseIn;
            double currAngle = 36.0 * (double)i;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean bl = mouseIn = mouseAngle > currAngle && mouseAngle < nextAngle;
            if (!mouseIn) continue;
            MenuItem item = RadialMenu.getActiveArray()[i];
            String string2 = string = item == null ? "Add Item" : item.title;
            if (GuiRadialMenu.func_146272_n() && item != null) {
                string = TextFormatting.RED + "EDIT: " + TextFormatting.WHITE + string;
            }
            int drawX = resolution.func_78326_a() / 2 - fontRenderer.func_78256_a(string) / 2;
            int drawY = resolution.func_78328_b() / 2;
            int drawWidth = mc.field_71466_p.func_78256_a(string);
            int drawHeight = mc.field_71466_p.field_78288_b;
            float padding = 5.0f;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179090_x();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float r = (float)ConfigHandler.menuRed / 255.0f;
            float g = (float)ConfigHandler.menuGreen / 255.0f;
            float b = (float)ConfigHandler.menuBlue / 255.0f;
            float alpha = (float)ConfigHandler.menuAlpha / 255.0f;
            bufferBuilder.func_181662_b((double)((float)drawX - padding), (double)((float)(drawY + drawHeight) + padding), 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            bufferBuilder.func_181662_b((double)((float)(drawX + drawWidth) + padding), (double)((float)(drawY + drawHeight) + padding), 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            bufferBuilder.func_181662_b((double)((float)(drawX + drawWidth) + padding), (double)((float)drawY - padding), 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            bufferBuilder.func_181662_b((double)((float)drawX - padding), (double)((float)drawY - padding), 0.0).func_181666_a(r, g, b, alpha).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            fontRenderer.func_175063_a(string, (float)drawX, (float)drawY, 0xFFFFFF);
        }
    }
}

