/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu;

import dmillerw.menu.data.session.EditSessionData;
import dmillerw.menu.gui.GuiStack;
import dmillerw.menu.helper.GuiRenderHelper;
import dmillerw.menu.helper.ItemRenderHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiPickIcon
extends GuiScreen {
    private static final int MAX_COLUMN = 14;
    private static final int MAX_ROW = 4;
    private GuiTextField textSearch;
    private GuiButton buttonCancel;
    private NonNullList<ItemStack> stacks;
    private int listScrollIndex = 0;

    public void func_73876_c() {
        this.textSearch.func_146178_a();
        if (this.textSearch.func_146179_b().trim().isEmpty()) {
            this.reconstructList(this.stacks);
        }
    }

    private void reconstructList(NonNullList<ItemStack> list) {
        list.clear();
        for (Item registryItem : ForgeRegistries.ITEMS) {
            Item item;
            ItemStack stack = new ItemStack((IItemProvider)registryItem);
            if (stack.func_190926_b() || stack == null || (item = stack.func_77973_b()).func_77640_w() == null) continue;
            item.func_150895_a(item.func_77640_w(), list);
        }
    }

    @Nullable
    public IGuiEventListener getFocused() {
        return this.textSearch;
    }

    public void func_73866_w_() {
        this.field_146297_k.field_195559_v.func_197967_a(true);
        this.stacks = NonNullList.func_191196_a();
        this.reconstructList(this.stacks);
        this.buttonCancel = new GuiButton(0, this.field_146294_l / 2 - 75, this.field_146295_m - 60 + 12, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiStack.pop();
            }
        };
        this.func_189646_b(this.buttonCancel);
        this.textSearch = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 150, 40, 300, 20);
        this.textSearch.func_146203_f(Short.MAX_VALUE);
        this.textSearch.func_146195_b(true);
    }

    public void func_146281_b() {
        this.field_146297_k.field_195559_v.func_197967_a(false);
    }

    public boolean func_73868_f() {
        return false;
    }

    public boolean charTyped(char key, int keyCode) {
        block5: {
            if (!this.textSearch.charTyped(key, (int)key)) break block5;
            this.listScrollIndex = 0;
            if (!this.textSearch.func_146179_b().trim().isEmpty()) {
                this.stacks.clear();
                NonNullList temp = NonNullList.func_191196_a();
                if (this.textSearch.func_146179_b().equalsIgnoreCase(".inv")) {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        this.stacks.add((Object)stack.func_77946_l());
                    }
                } else {
                    this.reconstructList((NonNullList<ItemStack>)temp);
                    for (ItemStack stack : temp) {
                        if (!stack.func_200301_q().getString().toLowerCase().contains(this.textSearch.func_146179_b().toLowerCase())) continue;
                        this.stacks.add((Object)stack);
                    }
                }
            }
        }
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            GuiStack.pop();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        ItemStack clicked = this.getClickedStack(this.field_146294_l / 2, this.field_146295_m - (Minecraft.func_71410_x().field_195558_d.func_198087_p() - 80), mouseX, mouseY);
        if (!clicked.func_190926_b()) {
            EditSessionData.icon = clicked;
            GuiStack.pop();
        }
        return true;
    }

    public boolean mouseScrolled(double wheel) {
        if ((wheel = -wheel) < 0.0) {
            this.listScrollIndex -= 2;
            if (this.listScrollIndex < 0) {
                this.listScrollIndex = 0;
            }
            return true;
        }
        if (wheel > 0.0) {
            this.listScrollIndex += 2;
            if (this.listScrollIndex > Math.max(0, this.stacks.size() / 14) - 4) {
                this.listScrollIndex = Math.max(0, this.stacks.size() / 14 - 4);
            }
            return true;
        }
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partial) {
        this.func_146276_q_();
        this.textSearch.func_195608_a(mouseX, mouseY, partial);
        super.func_73863_a(mouseX, mouseY, partial);
        GuiRenderHelper.renderHeaderAndFooter(this, 25, 20, 5, "Select an Icon:");
        this.drawList(this.field_146294_l / 2, this.field_146295_m - (Minecraft.func_71410_x().field_195558_d.func_198087_p() - 80), mouseX, mouseY);
    }

    private void drawList(int x, int y, int mx, int my) {
        ItemStack highlighted = ItemStack.field_190927_a;
        int highlightedX = 0;
        int highlightedY = 0;
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > 4) break;
            GlStateManager.func_179094_E();
            boolean scaled = false;
            int actualDrawX = x + drawX * 20 - 140 + 10;
            int actualDrawY = y + drawY * 20;
            if (mx > actualDrawX - 8 && mx < actualDrawX + 20 - 8 && my > (actualDrawY -= 20 * this.listScrollIndex) - 8 && my < actualDrawY + 20 - 8) {
                scaled = true;
                highlighted = (ItemStack)this.stacks.get(i);
                highlightedX = actualDrawX / 2;
                highlightedY = actualDrawY / 2;
            }
            if (!scaled) {
                ItemRenderHelper.renderItem(actualDrawX, actualDrawY, (ItemStack)this.stacks.get(i));
            }
            GlStateManager.func_179121_F();
        }
        if (!highlighted.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
            ItemRenderHelper.renderItem(highlightedX, highlightedY, highlighted);
            GlStateManager.func_179121_F();
        }
    }

    @Nonnull
    private ItemStack getClickedStack(int x, int y, double mx, double my) {
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > 4) continue;
            float actualDrawX = x + drawX * 20 - 140 + 10;
            float actualDrawY = y + drawY * 20;
            actualDrawY -= (float)(20 * this.listScrollIndex);
            if (!(mx > (double)(actualDrawX - 8.0f)) || !(mx < (double)(actualDrawX + 20.0f - 8.0f)) || !(my > (double)(actualDrawY - 8.0f)) || !(my < (double)(actualDrawY + 20.0f - 8.0f))) continue;
            return (ItemStack)this.stacks.get(i);
        }
        return ItemStack.field_190927_a;
    }
}

