/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu.list;

import dmillerw.menu.gui.GuiStack;
import dmillerw.menu.gui.menu.GuiClickAction;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiKeyBindingList;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiControlList
extends GuiListExtended<GuiKeyBindingList.Entry> {
    private final Minecraft mc;
    private int maxWidth = 0;

    public GuiControlList(GuiScreen parent, Minecraft mc) {
        super(mc, parent.field_146294_l, parent.field_146295_m, 25, parent.field_146295_m - 20, 20);
        this.mc = mc;
        Object[] keyBindings = Minecraft.func_71410_x().field_71474_y.field_74324_K;
        Arrays.sort(keyBindings);
        String lastCategory = "";
        for (Object keybinding : keyBindings) {
            int width;
            String category = keybinding.func_151466_e();
            if (keybinding.func_151464_g().equalsIgnoreCase("key.open_menu")) continue;
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                this.func_195085_a((GuiListExtended.IGuiListEntry)new CategoryEntry(category));
            }
            if ((width = mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)keybinding.func_151464_g(), (Object[])new Object[0]))) > this.maxWidth) {
                this.maxWidth = width;
            }
            this.func_195085_a((GuiListExtended.IGuiListEntry)new KeyEntry((KeyBinding)keybinding));
        }
    }

    public int func_148139_c() {
        return super.func_148139_c() + 32;
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 15;
    }

    protected void drawContainerBackground(Tessellator tessellator) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends GuiKeyBindingList.Entry {
        private final KeyBinding keyBinding;
        private final String description;
        private final GuiButton buttonSelect;

        KeyEntry(final KeyBinding keyBinding) {
            this.keyBinding = keyBinding;
            this.description = I18n.func_135052_a((String)keyBinding.func_151464_g(), (Object[])new Object[0]);
            this.buttonSelect = new GuiButton(0, 0, 0, 95, 18, this.description){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiClickAction.keyBinding = keyBinding;
                    GuiStack.pop();
                }
            };
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            int y = this.func_195001_c();
            int x = this.func_195002_d();
            ((GuiControlList)GuiControlList.this).mc.field_71466_p.func_211126_b(this.description, (float)(x + 90 - GuiControlList.this.maxWidth), (float)(y + entryHeight / 2 - ((GuiControlList)GuiControlList.this).mc.field_71466_p.field_78288_b / 2), 0xFFFFFF);
            this.buttonSelect.field_146128_h = x + 105;
            this.buttonSelect.field_146129_i = y;
            this.buttonSelect.field_146126_j = this.keyBinding.func_197978_k();
            this.buttonSelect.func_194828_a(mouseX, mouseY, partialTicks);
        }

        public boolean mouseClicked(double x, double y, int button) {
            return this.buttonSelect.mouseClicked(x, y, button);
        }

        public boolean mouseReleased(double x, double y, int button) {
            return this.buttonSelect.mouseReleased(x, y, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends GuiKeyBindingList.Entry {
        private final String category;
        private final int width;

        CategoryEntry(String category) {
            this.category = I18n.func_135052_a((String)category, (Object[])new Object[0]);
            this.width = ((GuiControlList)GuiControlList.this).mc.field_71466_p.func_78256_a(this.category);
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            if (((GuiControlList)GuiControlList.this).mc.field_71462_r != null) {
                ((GuiControlList)GuiControlList.this).mc.field_71466_p.func_211126_b(this.category, (float)(((GuiControlList)GuiControlList.this).mc.field_71462_r.field_146294_l / 2 - this.width / 2), (float)(this.func_195001_c() + GuiControlList.this.field_148149_f - ((GuiControlList)GuiControlList.this).mc.field_71466_p.field_78288_b - 1), 0xFFFFFF);
            }
        }
    }
}

