/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu;

import dmillerw.menu.data.click.ClickAction;
import dmillerw.menu.data.click.ClickActionCategory;
import dmillerw.menu.data.click.ClickActionCommand;
import dmillerw.menu.data.click.ClickActionKey;
import dmillerw.menu.data.click.ClickActionUseItem;
import dmillerw.menu.data.session.EditSessionData;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.gui.menu.PickItemScreen;
import dmillerw.menu.gui.menu.PickKeyScreen;
import dmillerw.menu.gui.menu.button.ItemButton;
import dmillerw.menu.helper.GuiRenderHelper;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class ClickActionScreen
extends Screen {
    @Nonnull
    public static ItemStack item;
    public static KeyBinding keyBinding;
    private static boolean toggle;
    private static boolean clipboard;
    private TextFieldWidget textCommand;
    private TextFieldWidget textCategory;
    private GuiButtonExt modeCommand;
    private GuiButtonExt modeKeybinding;
    private GuiButtonExt modeUseItem;
    private GuiButtonExt modeCategory;
    private Button commandClipboardButton;
    private Button keybindButton;
    private Button keybindToggleButton;
    private Button selectItemButton;
    private Button buttonCancel;
    private Button buttonConfirm;
    private int mode = 0;

    public ClickActionScreen() {
        super((ITextComponent)new TranslationTextComponent("minemenu.actionScreen.title", new Object[0]));
        keyBinding = null;
        item = ItemStack.field_190927_a;
    }

    public void tick() {
        this.textCommand.func_146178_a();
        this.textCategory.func_146178_a();
    }

    @Nullable
    public IGuiEventListener getFocused() {
        if (this.mode == 0) {
            return this.textCommand;
        }
        if (this.mode == 3) {
            return this.textCategory;
        }
        return super.getFocused();
    }

    public void init() {
        this.mode = keyBinding != null ? ClickAction.KEYBIND.ordinal() : (!item.func_190926_b() ? ClickAction.ITEM_USE.ordinal() : (EditSessionData.clickAction != null ? EditSessionData.clickAction.getClickAction().ordinal() : 0));
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.buttonConfirm = new Button(this.width / 2 - 4 - 150, this.height - 60, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), screen -> {
            if (this.mode == 0) {
                EditSessionData.clickAction = !this.textCommand.func_146179_b().trim().isEmpty() ? new ClickActionCommand(this.textCommand.func_146179_b().trim(), clipboard) : null;
            } else if (this.mode == 1 && keyBinding != null) {
                EditSessionData.clickAction = new ClickActionKey(keyBinding.func_151464_g(), toggle);
            } else if (this.mode == 2 && !item.func_190926_b()) {
                EditSessionData.clickAction = new ClickActionUseItem(item);
            } else if (this.mode == 3) {
                EditSessionData.clickAction = !this.textCategory.func_146179_b().trim().isEmpty() ? new ClickActionCategory(this.textCategory.func_146179_b().trim()) : null;
            }
            ScreenStack.pop();
        });
        this.addButton((Widget)this.buttonConfirm);
        this.buttonCancel = new Button(this.width / 2 + 4, this.height - 60, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), screen -> ScreenStack.pop());
        this.addButton((Widget)this.buttonCancel);
        String commandString = EditSessionData.clickAction instanceof ClickActionCommand ? (((ClickActionCommand)EditSessionData.clickAction).clipboard ? "Clipboard" : "Send") : (clipboard ? "Clipboard" : "Send");
        this.commandClipboardButton = new Button(this.width / 2 - 75, 80, 150, 20, commandString, screen -> {
            clipboard = !clipboard;
            this.commandClipboardButton.setMessage(clipboard ? "Clipboard" : "Send");
        });
        this.addButton((Widget)this.commandClipboardButton);
        String keyString = keyBinding != null ? I18n.func_135052_a((String)keyBinding.func_151464_g(), (Object[])new Object[0]) : (EditSessionData.clickAction instanceof ClickActionKey ? I18n.func_135052_a((String)((ClickActionKey)EditSessionData.clickAction).key, (Object[])new Object[0]) : "Select a key");
        this.keybindButton = new Button(this.width / 2 - 75, 50, 150, 20, keyString, screen -> ScreenStack.push(new PickKeyScreen()));
        this.addButton((Widget)this.keybindButton);
        String keyToggleString = EditSessionData.clickAction instanceof ClickActionKey ? (((ClickActionKey)EditSessionData.clickAction).toggle ? "Toggle" : "Press") : (toggle ? "Toggle" : "Press");
        this.keybindToggleButton = new Button(this.width / 2 - 75, 80, 150, 20, keyToggleString, screen -> {
            toggle = !toggle;
            this.keybindToggleButton.setMessage(toggle ? "Toggle" : "Press");
        });
        this.addButton((Widget)this.keybindToggleButton);
        String itemString = !item.func_190926_b() ? "Item: " + item.func_200301_q().getString() : (EditSessionData.clickAction != null && EditSessionData.clickAction.getClickAction() == ClickAction.ITEM_USE ? "Item: " + ((ClickActionUseItem)EditSessionData.clickAction).stack.func_77973_b().func_200296_o().getString() : "Select a Slot");
        this.selectItemButton = new Button(this.width / 2 - 75, 50, 150, 20, itemString, screen -> ScreenStack.push(new PickItemScreen()));
        this.addButton((Widget)this.selectItemButton);
        this.modeCommand = new ItemButton(this.width / 2 - 55, this.height - 90, 20, 20, new ItemStack((IItemProvider)Items.field_151121_aF), screen -> {
            this.mode = 0;
            this.modeCategory.active = true;
            this.modeUseItem.active = true;
            this.modeKeybinding.active = true;
            this.modeCommand.active = false;
            this.textCategory.func_146189_e(false);
            this.selectItemButton.visible = false;
            this.textCommand.func_146189_e(true);
            this.commandClipboardButton.visible = true;
            this.keybindButton.visible = false;
            this.keybindToggleButton.visible = false;
        });
        this.addButton((Widget)this.modeCommand);
        this.modeKeybinding = new ItemButton(this.width / 2 - 25, this.height - 90, 20, 20, new ItemStack((IItemProvider)Blocks.field_196689_eF), screen -> {
            this.mode = 1;
            this.modeCategory.active = true;
            this.modeUseItem.active = true;
            this.modeKeybinding.active = false;
            this.modeCommand.active = true;
            this.textCategory.func_146189_e(false);
            this.selectItemButton.visible = false;
            this.textCommand.func_146189_e(false);
            this.commandClipboardButton.visible = false;
            this.keybindButton.visible = true;
            this.keybindToggleButton.visible = true;
        });
        this.addButton((Widget)this.modeKeybinding);
        this.modeUseItem = new ItemButton(this.width / 2 + 5, this.height - 90, 20, 20, new ItemStack((IItemProvider)Items.field_151048_u), screen -> {
            this.mode = 2;
            this.modeCategory.active = true;
            this.modeUseItem.active = false;
            this.modeKeybinding.active = true;
            this.modeCommand.active = true;
            this.textCategory.func_146189_e(false);
            this.selectItemButton.visible = true;
            this.textCommand.func_146189_e(false);
            this.commandClipboardButton.visible = false;
            this.keybindButton.visible = false;
            this.keybindToggleButton.visible = false;
        });
        this.addButton((Widget)this.modeUseItem);
        this.modeCategory = new ItemButton(this.width / 2 + 35, this.height - 90, 20, 20, new ItemStack((IItemProvider)Blocks.field_150486_ae), screen -> {
            this.mode = 3;
            this.modeCategory.active = false;
            this.modeUseItem.active = true;
            this.modeKeybinding.active = true;
            this.modeCommand.active = true;
            this.textCategory.func_146189_e(true);
            this.selectItemButton.visible = false;
            this.textCommand.func_146189_e(false);
            this.commandClipboardButton.visible = false;
            this.keybindButton.visible = false;
            this.keybindToggleButton.visible = false;
        });
        this.addButton((Widget)this.modeCategory);
        this.textCommand = new TextFieldWidget(this.font, this.width / 2 - 150, 50, 300, 20, "minemenu.action.command");
        this.textCommand.func_146203_f(Short.MAX_VALUE);
        this.textCommand.changeFocus(true);
        this.textCommand.func_146180_a(EditSessionData.clickAction instanceof ClickActionCommand ? ((ClickActionCommand)EditSessionData.clickAction).command : "");
        this.textCategory = new TextFieldWidget(this.font, this.width / 2 - 150, 50, 300, 20, "minemenu.action.category");
        this.textCategory.func_146203_f(Short.MAX_VALUE);
        this.textCategory.changeFocus(true);
        this.textCategory.func_146180_a(EditSessionData.clickAction instanceof ClickActionCategory ? ((ClickActionCategory)EditSessionData.clickAction).category : "");
        this.modeCommand.active = this.mode != 0;
        this.modeKeybinding.active = this.mode != 1;
        this.modeUseItem.active = this.mode != 2;
        this.modeCategory.active = this.mode != 3;
        this.textCommand.func_146189_e(this.mode == 0);
        this.commandClipboardButton.visible = this.mode == 0;
        this.keybindButton.visible = this.mode == 1;
        this.keybindToggleButton.visible = this.mode == 1;
        this.selectItemButton.visible = this.mode == 2;
        this.textCategory.func_146189_e(this.mode == 3);
    }

    public void removed() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean charTyped(char key, int keycode) {
        this.textCommand.charTyped(key, keycode);
        this.textCategory.charTyped(key, keycode);
        return true;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        super.mouseClicked(mx, my, button);
        this.textCommand.mouseClicked(mx, my, button);
        return true;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            ScreenStack.pop();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void render(int mouseX, int mouseY, float partial) {
        this.renderBackground();
        this.textCommand.render(mouseX, mouseY, partial);
        this.textCategory.render(mouseX, mouseY, partial);
        super.render(mouseX, mouseY, partial);
        String header = "";
        switch (this.mode) {
            case 0: {
                header = "Enter a command";
                break;
            }
            case 1: {
                header = "Select a key";
                break;
            }
            case 2: {
                header = "Pick an item";
                break;
            }
            case 3: {
                header = "Enter a category";
            }
        }
        GuiRenderHelper.renderHeaderAndFooter(this, 25, 20, 5, header);
        if (mouseX > this.modeCommand.x && mouseX < this.modeCommand.x + this.modeCommand.getWidth() && mouseY > this.modeCommand.y && mouseY < this.modeCommand.y + this.modeCommand.getWidth()) {
            this.renderTooltip(Collections.singletonList("Click Action: Command"), mouseX, mouseY);
        } else if (mouseX > this.modeKeybinding.x && mouseX < this.modeKeybinding.x + this.modeKeybinding.getWidth() && mouseY > this.modeKeybinding.y && mouseY < this.modeKeybinding.y + this.modeKeybinding.getWidth()) {
            this.renderTooltip(Collections.singletonList("Click Action: KeyBinding"), mouseX, mouseY);
        } else if (mouseX > this.modeUseItem.x && mouseX < this.modeUseItem.x + this.modeUseItem.getWidth() && mouseY > this.modeUseItem.y && mouseY < this.modeUseItem.y + this.modeUseItem.getWidth()) {
            this.renderTooltip(Collections.singletonList("Click Action: Use Item"), mouseX, mouseY);
        } else if (mouseX > this.modeCategory.x && mouseX < this.modeCategory.x + this.modeCategory.getWidth() && mouseY > this.modeCategory.y && mouseY < this.modeCategory.y + this.modeCategory.getWidth()) {
            this.renderTooltip(Collections.singletonList("Click Action: Category"), mouseX, mouseY);
        }
    }

    static {
        toggle = false;
        clipboard = false;
    }
}

