/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu;

import com.mojang.blaze3d.platform.GlStateManager;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.gui.menu.ClickActionScreen;
import dmillerw.menu.helper.GuiRenderHelper;
import dmillerw.menu.helper.ItemRenderHelper;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PickItemScreen
extends Screen {
    private static final int XSIZE = 176;
    private static final int YSIZE = 166;
    private int guiLeft;
    private int guiTop;

    public PickItemScreen() {
        super((ITextComponent)new TranslationTextComponent("minemenu.itemScreen.title", new Object[0]));
    }

    public void init() {
        super.init();
        this.guiLeft = (this.width - 176) / 2;
        this.guiTop = (this.height - 166) / 2;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        GuiRenderHelper.renderHeaderAndFooter(this, 25, 20, 5, "Pick an Item:");
        this.getMinecraft().func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/inventory.png"));
        this.blit(this.guiLeft, this.guiTop, 0, 0, 176, 166);
        Slot mousedOver = null;
        GlStateManager.pushMatrix();
        for (int i1 = 0; i1 < this.getMinecraft().field_71439_g.field_71069_bz.field_75151_b.size(); ++i1) {
            Slot slot = (Slot)this.getMinecraft().field_71439_g.field_71069_bz.field_75151_b.get(i1);
            if (mouseX - this.guiLeft >= slot.field_75223_e && mouseX - this.guiLeft <= slot.field_75223_e + 16 && mouseY - this.guiTop >= slot.field_75221_f && mouseY - this.guiTop <= slot.field_75221_f + 16) {
                mousedOver = slot;
                continue;
            }
            this.drawSlot(slot, false);
        }
        if (mousedOver != null && !mousedOver.func_75211_c().func_190926_b()) {
            GlStateManager.pushMatrix();
            this.drawSlot(mousedOver, true);
            GlStateManager.popMatrix();
            this.renderTooltip(mousedOver.func_75211_c(), mouseX, mouseY);
        }
        GlStateManager.popMatrix();
    }

    private void drawSlot(Slot slot, boolean scale) {
        TextureAtlasSprite sprite;
        int x = slot.field_75223_e;
        int y = slot.field_75221_f;
        ItemStack stack = slot.func_75211_c();
        this.blitOffset = 100;
        this.itemRenderer.field_77023_b = 100.0f;
        if (stack.func_190926_b() && (sprite = slot.getBackgroundSprite()) != null) {
            GlStateManager.disableLighting();
            this.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            PickItemScreen.blit((int)(this.guiLeft + x), (int)(this.guiTop + y), (int)this.blitOffset, (int)16, (int)16, (TextureAtlasSprite)sprite);
            GlStateManager.enableLighting();
        }
        if (!stack.func_190926_b()) {
            if (scale) {
                GlStateManager.scaled((double)2.0, (double)2.0, (double)2.0);
                ItemRenderHelper.renderItem((this.guiLeft + x + 8) / 2, (this.guiTop + y + 8) / 2, stack);
            } else {
                ItemRenderHelper.renderItem(this.guiLeft + x + 8, this.guiTop + y + 8, stack);
            }
        }
        this.itemRenderer.field_77023_b = 0.0f;
        this.blitOffset = 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (int i1 = 0; i1 < this.getMinecraft().field_71439_g.field_71069_bz.field_75151_b.size(); ++i1) {
                ItemStack stack;
                Slot slot = (Slot)this.getMinecraft().field_71439_g.field_71069_bz.field_75151_b.get(i1);
                if (!(mouseX - (double)this.guiLeft >= (double)slot.field_75223_e) || !(mouseX - (double)this.guiLeft <= (double)(slot.field_75223_e + 16)) || !(mouseY - (double)this.guiTop >= (double)slot.field_75221_f) || !(mouseY - (double)this.guiTop <= (double)(slot.field_75221_f + 16)) || (stack = slot.func_75211_c()).func_190926_b()) continue;
                ClickActionScreen.item = stack.func_77946_l();
                ScreenStack.pop();
                return true;
            }
        }
        return false;
    }

    public void removed() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            ScreenStack.pop();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

