/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu.list;

import com.google.common.collect.ImmutableList;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.gui.menu.ClickActionScreen;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.gui.widget.list.KeyBindingList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiControlList
extends AbstractOptionList<KeyBindingList.Entry> {
    private final Minecraft mc;
    private int maxWidth = 0;

    public GuiControlList(Screen parent, Minecraft mc) {
        super(mc, parent.width, parent.height, 25, parent.height - 20, 20);
        this.mc = mc;
        Object[] keyBindings = Minecraft.func_71410_x().field_71474_y.field_74324_K;
        Arrays.sort(keyBindings);
        String lastCategory = "";
        for (Object keybinding : keyBindings) {
            int width;
            String category = keybinding.func_151466_e();
            if (keybinding.func_151464_g().equalsIgnoreCase("key.open_menu")) continue;
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                this.addEntry((AbstractList.AbstractListEntry)new CategoryEntry(category));
            }
            if ((width = mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)keybinding.func_151464_g(), (Object[])new Object[0]))) > this.maxWidth) {
                this.maxWidth = width;
            }
            this.addEntry((AbstractList.AbstractListEntry)new KeyEntry((KeyBinding)keybinding));
        }
    }

    public int getWidth() {
        return super.getWidth() + 32;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends KeyBindingList.Entry {
        private final KeyBinding keyBinding;
        private final String description;
        private final Button buttonSelect;

        KeyEntry(KeyBinding keyBinding) {
            this.keyBinding = keyBinding;
            this.description = I18n.func_135052_a((String)keyBinding.func_151464_g(), (Object[])new Object[0]);
            this.buttonSelect = new Button(0, 0, 95, 18, this.description, screen -> {
                ClickActionScreen.keyBinding = keyBinding;
                ScreenStack.pop();
            });
        }

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            FontRenderer fontRenderer = ((GuiControlList)GuiControlList.this).mc.field_71466_p;
            float f = p_render_3_ + 90 - GuiControlList.this.maxWidth;
            int n = p_render_2_ + p_render_5_ / 2;
            ((GuiControlList)GuiControlList.this).mc.field_71466_p.getClass();
            fontRenderer.func_211126_b(this.description, f, (float)(n - 9 / 2), 0xFFFFFF);
            this.buttonSelect.x = p_render_3_ + 105;
            this.buttonSelect.y = p_render_2_;
            this.buttonSelect.setMessage(this.keyBinding.func_197978_k());
            this.buttonSelect.render(p_render_6_, p_render_7_, p_render_9_);
        }

        @Nonnull
        public List<? extends IGuiEventListener> children() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        public boolean mouseClicked(double x, double y, int button) {
            return this.buttonSelect.mouseClicked(x, y, button);
        }

        public boolean mouseReleased(double x, double y, int button) {
            return this.buttonSelect.mouseReleased(x, y, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends KeyBindingList.Entry {
        private final String category;
        private final int width;

        CategoryEntry(String category) {
            this.category = I18n.func_135052_a((String)category, (Object[])new Object[0]);
            this.width = ((GuiControlList)GuiControlList.this).mc.field_71466_p.func_78256_a(this.category);
        }

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            FontRenderer fontRenderer = ((GuiControlList)GuiControlList.this).mc.field_71466_p;
            float f = Objects.requireNonNull(((GuiControlList)GuiControlList.this).minecraft.field_71462_r).width / 2 - this.width / 2;
            ((GuiControlList)GuiControlList.this).mc.field_71466_p.getClass();
            fontRenderer.func_211126_b(this.category, f, (float)(p_render_2_ + p_render_5_ - 9 - 1), 0xFFFFFF);
        }

        public boolean changeFocus(boolean changeFocus) {
            return false;
        }

        @Nonnull
        public List<? extends IGuiEventListener> children() {
            return Collections.emptyList();
        }
    }
}

