/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.handler;

import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.gui.RadialMenuScreen;
import dmillerw.menu.handler.ConfigHandler;
import dmillerw.menu.helper.KeyReflectionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minemenu", value={Dist.CLIENT})
public class KeyboardHandler {
    public static final KeyboardHandler INSTANCE = new KeyboardHandler();
    private static final KeyBinding WHEEL = new KeyBinding("key.open_menu", 82, "key.categories.misc");
    private static boolean lastWheelState = false;
    private static final List<KeyBinding> FIRED_KEYS = new ArrayList<KeyBinding>();
    private static final List<KeyBinding> TOGGLED_KEYS = new ArrayList<KeyBinding>();
    private static boolean ignoreNextTick = false;

    public static void register() {
        ClientRegistry.registerKeyBinding((KeyBinding)WHEEL);
    }

    private KeyboardHandler() {
    }

    public void fireKey(KeyBinding key) {
        FIRED_KEYS.add(key);
        KeyBinding.func_197980_a((InputMappings.Input)key.getKey(), (boolean)true);
        KeyReflectionHelper.setPressTime(key, 1);
        ignoreNextTick = true;
    }

    public void toggleKey(KeyBinding key) {
        if (!TOGGLED_KEYS.contains(key)) {
            TOGGLED_KEYS.add(key);
            KeyBinding.func_197980_a((InputMappings.Input)key.getKey(), (boolean)true);
            KeyReflectionHelper.setPressTime(key, 1);
        } else {
            TOGGLED_KEYS.remove(key);
            KeyBinding.func_197980_a((InputMappings.Input)key.getKey(), (boolean)false);
        }
        ignoreNextTick = true;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        KeyBinding keyBinding;
        boolean wheelKeyPressed;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        long handle = Minecraft.func_71410_x().field_195558_d.func_198092_i();
        boolean bl = wheelKeyPressed = WHEEL.getKey().func_197937_c() >= 0 ? InputMappings.func_216506_a((long)handle, (int)WHEEL.getKey().func_197937_c()) : InputMappings.func_216506_a((long)handle, (int)(WHEEL.getKey().func_197937_c() + 100));
        if (wheelKeyPressed != lastWheelState) {
            if (((Boolean)ConfigHandler.GENERAL.toggle.get()).booleanValue()) {
                if (wheelKeyPressed) {
                    if (RadialMenuScreen.active) {
                        if (((Boolean)ConfigHandler.GENERAL.releaseToSelect.get()).booleanValue()) {
                            RadialMenuScreen.INSTANCE.mouseClicked(mc.field_71417_B.func_198024_e(), mc.field_71417_B.func_198026_f(), 0);
                        }
                        RadialMenuScreen.deactivate();
                    } else if (mc.field_71462_r == null || mc.field_71462_r instanceof RadialMenuScreen) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        RadialMenuScreen.activate();
                    }
                }
            } else if (wheelKeyPressed != RadialMenuScreen.active) {
                if (wheelKeyPressed) {
                    if (mc.field_71462_r == null || mc.field_71462_r instanceof RadialMenuScreen) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        RadialMenuScreen.activate();
                    }
                } else {
                    if (((Boolean)ConfigHandler.GENERAL.releaseToSelect.get()).booleanValue()) {
                        RadialMenuScreen.INSTANCE.mouseClicked(mc.field_71417_B.func_198024_e(), mc.field_71417_B.func_198026_f(), 0);
                    }
                    RadialMenuScreen.deactivate();
                }
            }
        }
        lastWheelState = wheelKeyPressed;
        if (ignoreNextTick) {
            ignoreNextTick = false;
            return;
        }
        Iterator<KeyBinding> iterator = FIRED_KEYS.iterator();
        while (iterator.hasNext()) {
            keyBinding = iterator.next();
            KeyBinding.func_197980_a((InputMappings.Input)keyBinding.getKey(), (boolean)false);
            iterator.remove();
        }
        iterator = TOGGLED_KEYS.iterator();
        while (iterator.hasNext()) {
            keyBinding = iterator.next();
            if (!(keyBinding.getKey().func_197937_c() < 0 ? InputMappings.func_216506_a((long)handle, (int)(keyBinding.getKey().func_197937_c() + 100)) : keyBinding.func_151468_f()) && mc.field_71462_r == null) continue;
            iterator.remove();
        }
        for (KeyBinding keyBinding2 : TOGGLED_KEYS) {
            KeyReflectionHelper.setPressTime(keyBinding2, 1);
        }
    }
}

