/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu;

import dmillerw.menu.MineMenu;
import dmillerw.menu.data.click.ClickActionCommand;
import dmillerw.menu.data.click.ClickActionKey;
import dmillerw.menu.data.json.MenuLoader;
import dmillerw.menu.data.menu.MenuItem;
import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.data.session.EditSessionData;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.gui.menu.ClickActionScreen;
import dmillerw.menu.gui.menu.PickIconScreen;
import dmillerw.menu.gui.menu.button.ItemButton;
import dmillerw.menu.helper.GuiRenderHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MenuItemScreen
extends Screen {
    private final int slot;
    private TextFieldWidget textTitle;
    private Button buttonCancel;
    private Button buttonConfirm;
    private Button buttonDelete;
    private ItemButton buttonPickIcon;
    private Button buttonClickAction;

    public MenuItemScreen(int slot, MenuItem menuItem) {
        super((ITextComponent)new TranslationTextComponent("minemenu.itemScreen.title", new Object[0]));
        this.slot = slot;
        EditSessionData.fromMenuItem(menuItem);
    }

    public void tick() {
        this.textTitle.func_146178_a();
        this.buttonConfirm.visible = EditSessionData.clickAction != null;
        this.buttonDelete.visible = RadialMenu.getActiveArray()[this.slot] != null;
    }

    @Nullable
    public IGuiEventListener getFocused() {
        return this.textTitle;
    }

    public void init() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.buttonConfirm = new Button(this.width / 2 - 4 - 150, this.height - 60, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), screen -> {
            if (EditSessionData.title.isEmpty()) {
                EditSessionData.title = "Menu Item #" + this.slot;
            }
            if (EditSessionData.clickAction != null) {
                if (RadialMenu.getActiveArray()[this.slot] != null) {
                    RadialMenu.getActiveArray()[this.slot].onRemoved();
                }
                RadialMenu.getActiveArray()[this.slot] = EditSessionData.toMenuItem();
            }
            MenuLoader.save(MineMenu.menuFile);
            Minecraft.func_71410_x().func_147108_a(null);
        });
        this.addButton((Widget)this.buttonConfirm);
        this.buttonCancel = new Button(this.width / 2 + 4 + 50, this.height - 60, 100, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), screen -> Minecraft.func_71410_x().func_147108_a(null));
        this.addButton((Widget)this.buttonCancel);
        this.buttonDelete = new Button(this.width / 2 - 50, this.height - 60, 100, 20, "Delete", screen -> {
            if (RadialMenu.getActiveArray()[this.slot] != null) {
                RadialMenu.getActiveArray()[this.slot].onRemoved();
                RadialMenu.getActiveArray()[this.slot] = null;
                MenuLoader.save(MineMenu.menuFile);
                Minecraft.func_71410_x().func_147108_a(null);
            }
        });
        this.addButton((Widget)this.buttonDelete);
        this.buttonPickIcon = new ItemButton(this.width / 2 - 4 - 40, this.height / 2, 20, 20, new ItemStack((IItemProvider)Blocks.field_150348_b), screen -> ScreenStack.push(new PickIconScreen()));
        this.addButton((Widget)this.buttonPickIcon);
        String string = "Action";
        if (EditSessionData.clickAction != null) {
            if (EditSessionData.clickAction instanceof ClickActionCommand) {
                string = "Command";
            } else if (EditSessionData.clickAction instanceof ClickActionKey) {
                string = "Keybind";
            }
        }
        this.buttonClickAction = new Button(this.width / 2 - 20, this.height / 2, 100, 20, string, screen -> ScreenStack.push(new ClickActionScreen()));
        this.addButton((Widget)this.buttonClickAction);
        this.textTitle = new TextFieldWidget(this.font, this.width / 2 - 150, 50, 300, 20, "minemenu.menuItem.title");
        this.textTitle.func_146203_f(Short.MAX_VALUE);
        this.textTitle.func_146180_a(EditSessionData.title != null && !EditSessionData.title.isEmpty() ? EditSessionData.title : "");
        this.buttonPickIcon.icon = EditSessionData.icon;
    }

    public void removed() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean charTyped(char key, int keycode) {
        if (this.textTitle.charTyped(key, keycode)) {
            EditSessionData.title = this.textTitle.func_146179_b().trim();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        super.mouseClicked(mx, my, button);
        this.textTitle.mouseClicked(mx, my, button);
        return true;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            ScreenStack.pop();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void render(int mouseX, int mouseY, float partial) {
        this.renderBackground();
        this.textTitle.render(mouseX, mouseY, partial);
        this.drawCenteredString(this.font, "Enter a title, then configure using the options below", this.width / 2, 80, 0xFFFFFF);
        super.render(mouseX, mouseY, partial);
        GuiRenderHelper.renderHeaderAndFooter(this, 25, 20, 5, "Modifying Menu Item #" + this.slot);
    }
}

