/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import dmillerw.menu.data.session.EditSessionData;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.helper.GuiRenderHelper;
import dmillerw.menu.helper.ItemRenderHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class PickIconScreen
extends Screen {
    private static final int MAX_COLUMN = 14;
    private static final int MAX_ROW = 4;
    private TextFieldWidget textSearch;
    private Button buttonCancel;
    private NonNullList<ItemStack> stacks;
    private int listScrollIndex = 0;

    public PickIconScreen() {
        super((ITextComponent)new TranslationTextComponent("minemenu.iconScreen.title", new Object[0]));
    }

    public void tick() {
        this.textSearch.func_146178_a();
        if (this.textSearch.func_146179_b().trim().isEmpty()) {
            this.reconstructList(this.stacks);
        }
    }

    private void reconstructList(NonNullList<ItemStack> list) {
        list.clear();
        for (Item registryItem : ForgeRegistries.ITEMS) {
            Item item;
            ItemStack stack = new ItemStack((IItemProvider)registryItem);
            if (stack.func_190926_b() || stack == null || (item = stack.func_77973_b()).func_77640_w() == null) continue;
            item.func_150895_a(item.func_77640_w(), list);
        }
    }

    @Nullable
    public IGuiEventListener getFocused() {
        return this.textSearch;
    }

    public void init() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.stacks = NonNullList.func_191196_a();
        this.reconstructList(this.stacks);
        this.buttonCancel = new Button(this.width / 2 - 75, this.height - 60 + 12, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), screen -> ScreenStack.pop());
        this.addButton((Widget)this.buttonCancel);
        this.textSearch = new TextFieldWidget(this.font, this.width / 2 - 150, 40, 300, 20, "minemenu.pickIcon.search");
        this.textSearch.func_146203_f(Short.MAX_VALUE);
        this.textSearch.changeFocus(true);
    }

    public void removed() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean charTyped(char key, int keyCode) {
        block5: {
            if (!this.textSearch.charTyped(key, (int)key)) break block5;
            this.listScrollIndex = 0;
            if (!this.textSearch.func_146179_b().trim().isEmpty()) {
                this.stacks.clear();
                NonNullList temp = NonNullList.func_191196_a();
                if (this.textSearch.func_146179_b().equalsIgnoreCase(".inv")) {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        this.stacks.add((Object)stack.func_77946_l());
                    }
                } else {
                    this.reconstructList((NonNullList<ItemStack>)temp);
                    for (ItemStack stack : temp) {
                        if (!stack.func_200301_q().getString().toLowerCase().contains(this.textSearch.func_146179_b().toLowerCase())) continue;
                        this.stacks.add((Object)stack);
                    }
                }
            }
        }
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            ScreenStack.pop();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        ItemStack clicked = this.getClickedStack(this.width / 2, this.height - (Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 80), mouseX, mouseY);
        if (!clicked.func_190926_b()) {
            EditSessionData.icon = clicked;
            ScreenStack.pop();
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double wheel) {
        if ((wheel = -wheel) < 0.0) {
            this.listScrollIndex -= 2;
            if (this.listScrollIndex < 0) {
                this.listScrollIndex = 0;
            }
            return true;
        }
        if (wheel > 0.0) {
            this.listScrollIndex += 2;
            if (this.listScrollIndex > Math.max(0, this.stacks.size() / 14) - 4) {
                this.listScrollIndex = Math.max(0, this.stacks.size() / 14 - 4);
            }
            return true;
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partial) {
        this.renderBackground();
        this.textSearch.render(mouseX, mouseY, partial);
        super.render(mouseX, mouseY, partial);
        GuiRenderHelper.renderHeaderAndFooter(this, 25, 20, 5, "Select an Icon:");
        this.drawList(this.width / 2, this.height - (Minecraft.func_71410_x().func_228018_at_().func_198087_p() - 80), mouseX, mouseY);
    }

    private void drawList(int x, int y, int mx, int my) {
        ItemStack highlighted = ItemStack.field_190927_a;
        int highlightedX = 0;
        int highlightedY = 0;
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > 4) break;
            RenderSystem.pushMatrix();
            boolean scaled = false;
            int actualDrawX = x + drawX * 20 - 140 + 10;
            int actualDrawY = y + drawY * 20;
            if (mx > actualDrawX - 8 && mx < actualDrawX + 20 - 8 && my > (actualDrawY -= 20 * this.listScrollIndex) - 8 && my < actualDrawY + 20 - 8) {
                scaled = true;
                highlighted = (ItemStack)this.stacks.get(i);
                highlightedX = actualDrawX / 2;
                highlightedY = actualDrawY / 2;
            }
            if (!scaled) {
                ItemRenderHelper.renderItem(actualDrawX, actualDrawY, (ItemStack)this.stacks.get(i));
            }
            RenderSystem.popMatrix();
        }
        if (!highlighted.func_190926_b()) {
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)2.0, (double)2.0, (double)2.0);
            ItemRenderHelper.renderItem(highlightedX, highlightedY, highlighted);
            RenderSystem.popMatrix();
        }
    }

    @Nonnull
    private ItemStack getClickedStack(int x, int y, double mx, double my) {
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > 4) continue;
            float actualDrawX = x + drawX * 20 - 140 + 10;
            float actualDrawY = y + drawY * 20;
            actualDrawY -= (float)(20 * this.listScrollIndex);
            if (!(mx > (double)(actualDrawX - 8.0f)) || !(mx < (double)(actualDrawX + 20.0f - 8.0f)) || !(my > (double)(actualDrawY - 8.0f)) || !(my < (double)(actualDrawY + 20.0f - 8.0f))) continue;
            return (ItemStack)this.stacks.get(i);
        }
        return ItemStack.field_190927_a;
    }
}

