/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.network.packet.server;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUseItem {
    private int slot;

    public PacketUseItem(int slot) {
        this.slot = slot;
    }

    public static void encode(PacketUseItem pingPacket, PacketBuffer buf) {
        buf.writeInt(pingPacket.slot);
    }

    public static PacketUseItem decode(PacketBuffer buf) {
        return new PacketUseItem(buf.readInt());
    }

    private static EquipmentSlotType getSlotFromHand(Hand hand) {
        return hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
    }

    public static class Handler {
        public static void handle(PacketUseItem message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity player = ctx.get().getSender();
            if (player != null) {
                ItemStack slotStack = player.field_71071_by.func_70301_a(message.slot);
                ItemStack heldSaved = player.func_184614_ca();
                Hand hand = Hand.MAIN_HAND;
                EquipmentSlotType slot = PacketUseItem.getSlotFromHand(hand);
                player.func_184201_a(slot, slotStack);
                ItemStack heldItem = player.func_184586_b(hand);
                ActionResult useStack = heldItem.func_77957_a(player.field_70170_p, (PlayerEntity)player, hand);
                if (useStack.func_188397_a() == ActionResultType.SUCCESS) {
                    player.field_71071_by.field_70462_a.set(message.slot, useStack.func_188398_b());
                }
                player.func_184201_a(slot, heldSaved);
                player.func_71120_a((Container)player.field_71069_bz);
                ctx.get().setPacketHandled(true);
            }
        }
    }
}

