/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.data.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;

public class ItemStackSerializer
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.add("name", (JsonElement)new JsonPrimitive(String.valueOf(GameData.getItemRegistry().getNameForObject((Object)src.func_77973_b()))));
        object.add("damage", (JsonElement)new JsonPrimitive((Number)src.func_77952_i()));
        return object;
    }

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        String name = "";
        int damage = 0;
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (key.equals("name")) {
                name = element.getAsString();
                continue;
            }
            if (!key.equals("damage")) continue;
            damage = element.getAsInt();
        }
        return name.isEmpty() ? null : new ItemStack((Item)GameData.getItemRegistry().getObject(new ResourceLocation(name)), 1, damage);
    }
}

