/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins;

import com.mojang.authlib.GameProfile;
import lain.mods.skins.SkinData;
import lain.mods.skins.api.ISkin;
import lain.mods.skins.api.ISkinProviderService;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.providers.CrafatarCachedCapeProvider;
import lain.mods.skins.providers.CrafatarCachedSkinProvider;
import lain.mods.skins.providers.MojangCachedCapeProvider;
import lain.mods.skins.providers.MojangCachedSkinProvider;
import lain.mods.skins.providers.UserManagedCapeProvider;
import lain.mods.skins.providers.UserManagedSkinProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="offlineskins", useMetadata=true, acceptedMinecraftVersions="[1.10],[1.10.2]")
public class OfflineSkins {
    private static boolean SkinPass = false;
    @SideOnly(value=Side.CLIENT)
    public static ISkinProviderService skinService;
    @SideOnly(value=Side.CLIENT)
    public static ISkinProviderService capeService;

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation bindTexture(GameProfile profile, ResourceLocation result) {
        ISkin skin;
        if (SkinData.isDefaultSkin(result) && profile != null && (skin = skinService.getSkin(profile)) != null && skin.isSkinReady()) {
            return skin.getSkinLocation();
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getLocationCape(AbstractClientPlayer player, ResourceLocation result) {
        ISkin cape;
        if (result == null && capeService != null && (cape = capeService.getSkin(player.func_146103_bH())) != null && cape.isSkinReady()) {
            return cape.getSkinLocation();
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getLocationSkin(AbstractClientPlayer player, ResourceLocation result) {
        ISkin skin;
        if (SkinPass) {
            return result;
        }
        if (OfflineSkins.usingDefaultSkin(player) && skinService != null && (skin = skinService.getSkin(player.func_146103_bH())) != null && skin.isSkinReady()) {
            return skin.getSkinLocation();
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getSkinType(AbstractClientPlayer player, String result) {
        ISkin skin;
        if (OfflineSkins.usingDefaultSkin(player) && skinService != null && (skin = skinService.getSkin(player.func_146103_bH())) != null && skin.isSkinReady()) {
            return skin.getSkinType();
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean usingDefaultSkin(AbstractClientPlayer player) {
        try {
            SkinPass = true;
            boolean bl = SkinData.isDefaultSkin(player.func_110306_p());
            return bl;
        }
        finally {
            SkinPass = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleClientTicks(TickEvent.ClientTickEvent event) {
        WorldClient world;
        if (skinService == null && capeService == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && (world = Minecraft.func_71410_x().field_71441_e) != null && world.field_73010_i != null && !world.field_73010_i.isEmpty()) {
            for (Object obj : world.field_73010_i) {
                if (!(obj instanceof AbstractClientPlayer)) continue;
                if (skinService != null) {
                    skinService.getSkin(((AbstractClientPlayer)obj).func_146103_bH());
                }
                if (capeService == null) continue;
                capeService.getSkin(((AbstractClientPlayer)obj).func_146103_bH());
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        if (event.getSide().isClient()) {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            boolean useCrafatar = config.get("client", "useCrafatar", true).getBoolean(true);
            if (config.hasChanged()) {
                config.save();
            }
            skinService = SkinProviderAPI.createService();
            capeService = SkinProviderAPI.createService();
            skinService.register(new MojangCachedSkinProvider());
            skinService.register(new UserManagedSkinProvider());
            if (useCrafatar) {
                skinService.register(new CrafatarCachedSkinProvider());
            }
            capeService.register(new MojangCachedCapeProvider());
            capeService.register(new UserManagedCapeProvider());
            if (useCrafatar) {
                capeService.register(new CrafatarCachedCapeProvider());
            }
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }
}

