/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import java.awt.image.BufferedImage;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Shared {
    protected static final ExecutorService pool = Executors.newCachedThreadPool();
    protected static final BufferedImage dummy = new BufferedImage(1, 1, 2);
    private static final LoadingCache<GameProfile, Boolean> profileOnlineStatus = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<GameProfile, Boolean>(){

        public Boolean load(GameProfile key) throws Exception {
            return !UUID.nameUUIDFromBytes(("OfflinePlayer:" + key.getName()).getBytes(Charsets.UTF_8)).equals(key.getId());
        }
    });

    public static boolean isOfflineProfile(GameProfile profile) {
        if (profile == null || profile.getId() == null) {
            return true;
        }
        return (Boolean)profileOnlineStatus.getUnchecked((Object)profile) == false;
    }
}

