/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.asm;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import lain.mods.skins.asm.Plugin;
import lain.mods.skins.asm.Setup;
import org.apache.commons.lang3.Validate;

public class ObfHelper {
    private int type;
    private String[] data = new String[3];

    public static ObfHelper newClass(String className) {
        Validate.notNull((Object)className);
        ObfHelper result = new ObfHelper();
        result.type = 2;
        result.data[0] = className;
        result.transform(!Plugin.runtimeDeobfuscationEnabled);
        return result;
    }

    public static ObfHelper newField(String fieldName, String ownerName, String descriptor) {
        Validate.notNull((Object)fieldName);
        Validate.notNull((Object)ownerName);
        Validate.notNull((Object)descriptor);
        ObfHelper result = new ObfHelper();
        result.type = 3;
        result.data[0] = ownerName;
        result.data[1] = fieldName;
        result.data[2] = descriptor;
        result.transform(!Plugin.runtimeDeobfuscationEnabled);
        return result;
    }

    public static ObfHelper newMethod(String methodName, String ownerName, String descriptor) {
        Validate.notNull((Object)methodName);
        Validate.notNull((Object)ownerName);
        Validate.notNull((Object)descriptor);
        ObfHelper result = new ObfHelper();
        result.type = 4;
        result.data[0] = ownerName;
        result.data[1] = methodName;
        result.data[2] = descriptor;
        result.transform(!Plugin.runtimeDeobfuscationEnabled);
        return result;
    }

    public static ObfHelper newPackage(String packageName) {
        Validate.notNull((Object)packageName);
        ObfHelper result = new ObfHelper();
        result.type = 1;
        result.data[0] = packageName;
        result.transform(!Plugin.runtimeDeobfuscationEnabled);
        return result;
    }

    private ObfHelper() {
    }

    public String getData(int index) {
        if (index >= 0 && index <= 2) {
            return this.data[index];
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public boolean match(Object ... obj) {
        switch (this.type) {
            case 1: {
                if (obj.length != 1) break;
                return this.data[0].equals(obj[0]);
            }
            case 2: {
                if (obj.length != 1) break;
                return this.data[0].equals(obj[0]);
            }
            case 3: {
                if (obj.length == 1) {
                    return this.data[1].equals(obj[0]);
                }
                if (obj.length != 2) break;
                return this.data[0].equals(obj[0]) && this.data[1].equals(obj[1]);
            }
            case 4: {
                if (obj.length == 2) {
                    return this.data[1].equals(obj[0]) && this.data[2].equals(obj[1]);
                }
                if (obj.length != 3) break;
                return this.data[0].equals(obj[0]) && this.data[1].equals(obj[1]) && this.data[2].equals(obj[2]);
            }
        }
        return false;
    }

    public ObfHelper setDevName(String name) {
        return this.setDevName(name, Plugin.isDevelopmentEnvironment);
    }

    private ObfHelper setDevName(String name, boolean devEnv) {
        if (devEnv) {
            switch (this.type) {
                case 1: {
                    this.data[0] = name;
                    break;
                }
                case 2: {
                    this.data[0] = name;
                    break;
                }
                case 3: {
                    this.data[1] = name;
                    break;
                }
                case 4: {
                    this.data[1] = name;
                }
            }
        }
        return this;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return String.format("ObfHelper:Package{%s}", this.data[0]);
            }
            case 2: {
                return String.format("ObfHelper:Class{%s}", this.data[0]);
            }
            case 3: {
                return String.format("ObfHelper:Field{%s/%s %s}", this.data[0], this.data[1], this.data[2]);
            }
            case 4: {
                return String.format("ObfHelper:Method{%s/%s %s}", this.data[0], this.data[1], this.data[2]);
            }
        }
        return String.format("ObfHelper:Unknown(%d){%s %s %s}", this.type, this.data[0], this.data[1], this.data[2]);
    }

    private void transform(boolean deobfuscated) {
        switch (this.type) {
            case 1: {
                BiMap map1;
                BiMap biMap = map1 = deobfuscated ? Setup.PackageMap : Setup.PackageMap.inverse();
                if (!map1.containsKey(this.data[0])) break;
                this.data[0] = (String)map1.get(this.data[0]);
                break;
            }
            case 2: {
                BiMap map2;
                BiMap biMap = map2 = deobfuscated ? Setup.ClassMap : Setup.ClassMap.inverse();
                if (!map2.containsKey(this.data[0])) break;
                this.data[0] = (String)map2.get(this.data[0]);
                break;
            }
            case 3: {
                BiMap map3 = deobfuscated ? Setup.FieldMap : Setup.FieldMap.inverse();
                Object list3 = ImmutableList.of((Object)this.data[0], (Object)this.data[1]);
                if (!map3.containsKey(list3)) break;
                list3 = (List)map3.get(list3);
                this.data[0] = (String)list3.get(0);
                this.data[1] = (String)list3.get(1);
                break;
            }
            case 4: {
                BiMap map4 = deobfuscated ? Setup.MethodMap : Setup.MethodMap.inverse();
                Object list4 = ImmutableList.of((Object)this.data[0], (Object)this.data[1], (Object)this.data[2]);
                if (!map4.containsKey(list4)) break;
                list4 = (List)map4.get(list4);
                this.data[0] = (String)list4.get(0);
                this.data[1] = (String)list4.get(1);
                this.data[2] = (String)list4.get(2);
            }
        }
    }
}

