/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.function.Function;
import lain.lib.SharedPool;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.impl.Shared;
import lain.mods.skins.impl.SkinData;
import lain.mods.skins.impl.fabric.ImageUtils;

public class UserManagedSkinProvider
implements ISkinProvider {
    private File _dirN;
    private File _dirU;
    private Function<ByteBuffer, ByteBuffer> _filter;

    public UserManagedSkinProvider(Path workDir) {
        this._dirN = new File(workDir.toFile(), "skins");
        this._dirN.mkdirs();
        this._dirU = new File(this._dirN, "uuid");
        this._dirU.mkdirs();
    }

    @Override
    public ISkin getSkin(IPlayerProfile profile) {
        SkinData skin = new SkinData();
        if (this._filter != null) {
            skin.setSkinFilter(this._filter);
        }
        SharedPool.execute(() -> {
            byte[] data = null;
            if (!Shared.isOfflinePlayer(profile.getPlayerID(), profile.getPlayerName())) {
                data = this.readFile(this._dirU, "%s.png", profile.getPlayerID().toString().replaceAll("-", ""));
            }
            if (data == null && !Shared.isBlank(profile.getPlayerName())) {
                data = this.readFile(this._dirN, "%s.png", profile.getPlayerName());
            }
            if (data != null) {
                skin.put(data, ImageUtils.judgeSkinType(data));
            }
        });
        return skin;
    }

    private byte[] readFile(File dir, String filename) {
        byte[] contents = Shared.blockyReadFile(new File(dir, filename), null, null);
        if (contents != null && ImageUtils.validateData(contents)) {
            return contents;
        }
        return null;
    }

    private byte[] readFile(File dir, String filename, Object ... args) {
        return this.readFile(dir, String.format(filename, args));
    }

    public UserManagedSkinProvider withFilter(Function<ByteBuffer, ByteBuffer> filter) {
        this._filter = filter;
        return this;
    }
}

