/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import lain.mods.skins.api.ISkin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class SkinData
implements ISkin {
    private static Set<String> DefaultSkins = ImmutableSet.of((Object)"textures/entity/steve.png", (Object)"textures/entity/alex.png");
    public GameProfile profile;
    private String type;
    private BufferedImage image;
    private ResourceLocation location;
    private CachedTexture texture;

    public static boolean isDefaultSkin(ResourceLocation location) {
        if (location == null || !"minecraft".equals(location.func_110624_b())) {
            return false;
        }
        return DefaultSkins.contains(location.func_110623_a());
    }

    public static String judgeSkinType(BufferedImage image) {
        if (image.getWidth() == 64) {
            int height = image.getHeight();
            if (height == 32) {
                return "legacy";
            }
            if (height == 64) {
                if ((image.getRGB(55, 20) & 0xFF000000) >>> 24 == 0) {
                    return "slim";
                }
                return "default";
            }
        }
        return "unknown";
    }

    public SkinData() {
        this(new ResourceLocation("offlineskins", String.format("textures/entity/generated/%s", UUID.randomUUID())));
    }

    public SkinData(ResourceLocation location) {
        this.location = location;
    }

    @Override
    public ResourceLocation getSkinLocation() {
        if (this.image != null && this.location != null && (this.texture == null || this.texture.image != this.image)) {
            if (this.texture != null) {
                this.texture.func_147631_c();
            }
            this.texture = new CachedTexture(this.image);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(this.location, (ITextureObject)this.texture);
        }
        return this.location;
    }

    @Override
    public String getSkinType() {
        return this.type;
    }

    @Override
    public boolean isSkinReady() {
        return this.image != null;
    }

    @Override
    public void onRemoval() {
        if (this.texture != null) {
            this.texture.func_147631_c();
            this.texture = null;
        }
    }

    public void put(BufferedImage image, String type) {
        if (image != null && type == null) {
            type = SkinData.judgeSkinType(image);
        }
        this.type = type;
        this.image = image;
    }

    class CachedTexture
    extends AbstractTexture {
        final BufferedImage image;

        CachedTexture(BufferedImage image) {
            this.image = image;
        }

        public void func_110551_a(IResourceManager arg0) throws IOException {
            this.func_147631_c();
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)this.image, (boolean)false, (boolean)false);
        }
    }
}

