/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.api;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lain.mods.skins.api.ISkin;
import lain.mods.skins.api.ISkinProvider;
import lain.mods.skins.api.ISkinProviderService;
import net.minecraft.client.entity.AbstractClientPlayer;

public class SkinProviderAPI {
    public static ISkinProviderService createService() {
        return new ISkinProviderService(){
            private final List<ISkinProvider> providers = Lists.newArrayList();
            private final LoadingCache<AbstractClientPlayer, List<ISkin>> cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<AbstractClientPlayer, List<ISkin>>(){

                public void onRemoval(RemovalNotification<AbstractClientPlayer, List<ISkin>> notification) {
                    List list = (List)notification.getValue();
                    if (list != null) {
                        for (ISkin skin : list) {
                            skin.onRemoval();
                        }
                    }
                }
            }).build((CacheLoader)new CacheLoader<AbstractClientPlayer, List<ISkin>>(){

                public List<ISkin> load(AbstractClientPlayer key) throws Exception {
                    ArrayList list = Lists.newArrayList();
                    for (ISkinProvider p : providers) {
                        try {
                            ISkin s = p.getSkin(key);
                            if (s == null) continue;
                            list.add(s);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return list;
                }
            });

            @Override
            public void clear() {
                this.providers.clear();
                this.cache.invalidateAll();
            }

            @Override
            public ISkin getSkin(AbstractClientPlayer player) {
                List list = (List)this.cache.getUnchecked((Object)player);
                for (ISkin skin : list) {
                    if (!skin.isSkinReady()) continue;
                    return skin;
                }
                return null;
            }

            @Override
            public void register(ISkinProvider provider) {
                if (provider == null || provider == this) {
                    throw new UnsupportedOperationException();
                }
                this.providers.add(provider);
            }
        };
    }
}

