/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import com.google.common.base.Strings;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.UUID;
import javax.imageio.ImageIO;
import lain.mods.skins.PlayerUtils;
import lain.mods.skins.SkinData;
import lain.mods.skins.api.ISkin;
import lain.mods.skins.api.ISkinProvider;
import lain.mods.skins.providers.Shared;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CrafatarCachedCapeProvider
implements ISkinProvider {
    private File _workDir;

    public CrafatarCachedCapeProvider() {
        File file2;
        File file1 = new File(Minecraft.func_71410_x().field_71412_D, "cachedImages");
        if (!file1.exists()) {
            file1.mkdirs();
        }
        if (!(file2 = new File(file1, "crafatar")).exists()) {
            file2.mkdirs();
        }
        this._workDir = new File(file2, "capes");
        this.prepareWorkDir(this._workDir);
    }

    @Override
    public ISkin getSkin(AbstractClientPlayer player) {
        final SkinData data = new SkinData();
        data.profile = player.func_146103_bH();
        final boolean skipUUID = PlayerUtils.isOfflinePlayer((EntityPlayer)player);
        final UUID fbID = player.func_110124_au();
        Shared.pool.execute(new Runnable(){

            @Override
            public void run() {
                int n;
                BufferedImage image = null;
                UUID uuid = (UUID)ObjectUtils.defaultIfNull((Object)data.profile.getId(), (Object)fbID);
                String name = (String)ObjectUtils.defaultIfNull((Object)data.profile.getName(), (Object)"");
                if (!skipUUID) {
                    for (n = 0; n < 5; ++n) {
                        try {
                            image = CrafatarCachedCapeProvider.this.readImageCached(CrafatarCachedCapeProvider.this._workDir, uuid.toString(), new URL(String.format("https://crafatar.com/capes/%s", uuid)), Minecraft.func_71410_x().func_110437_J());
                            if (image == null) continue;
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (image == null) {
                    for (n = 0; n < 5; ++n) {
                        try {
                            image = CrafatarCachedCapeProvider.this.readImageCached(CrafatarCachedCapeProvider.this._workDir, name, new URL(String.format("https://crafatar.com/capes/%s", name)), Minecraft.func_71410_x().func_110437_J());
                            if (image == null) continue;
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (image != null && image != Shared.dummy) {
                    data.put(image, "cape");
                }
            }
        });
        return data;
    }

    private void prepareWorkDir(File workDir) {
        if (!workDir.exists()) {
            workDir.mkdirs();
        } else {
            for (File f : workDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".validtime");
                }
            })) {
                String validtime = null;
                try {
                    validtime = Strings.emptyToNull((String)FileUtils.readFileToString((File)f, (String)"UTF-8"));
                }
                catch (IOException e) {
                    validtime = null;
                }
                long t = -1L;
                try {
                    t = validtime != null ? Long.parseLong(validtime) : -1L;
                }
                catch (NumberFormatException e) {
                    t = -1L;
                }
                if (System.currentTimeMillis() < t) continue;
                String name = f.getName().substring(0, f.getName().length() - 10);
                File f1 = new File(f.getParentFile(), name);
                File f2 = new File(f.getParentFile(), name + ".etag");
                File f3 = f;
                if (f1.exists()) {
                    f1.delete();
                }
                if (f2.exists()) {
                    f2.delete();
                }
                if (!f3.exists()) continue;
                f3.delete();
            }
        }
    }

    private BufferedImage readImageCached(File workDir, String local, URL remote, Proxy proxy) throws IOException {
        File file1 = new File(workDir, local);
        File file2 = new File(workDir, local + ".etag");
        File file3 = new File(workDir, local + ".validtime");
        String etag = null;
        if (file1.exists() && file2.exists()) {
            try {
                etag = Strings.emptyToNull((String)FileUtils.readFileToString((File)file2, (String)"UTF-8"));
            }
            catch (IOException e) {
                etag = null;
            }
        }
        String validtime = null;
        try {
            validtime = Strings.emptyToNull((String)FileUtils.readFileToString((File)file3, (String)"UTF-8"));
        }
        catch (IOException e) {
            validtime = null;
        }
        long t = -1L;
        try {
            t = validtime != null ? Long.parseLong(validtime) : -1L;
        }
        catch (NumberFormatException e) {
            t = -1L;
        }
        HttpURLConnection conn = (HttpURLConnection)remote.openConnection(proxy);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(10000);
        if (etag != null && System.currentTimeMillis() < t) {
            conn.setRequestProperty("If-None-Match", etag);
        }
        conn.connect();
        int code = conn.getResponseCode();
        if (code / 100 == 2) {
            etag = Strings.emptyToNull((String)conn.getHeaderField("Etag"));
            t = Math.max(conn.getExpiration(), System.currentTimeMillis() + 60000L);
            try {
                FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)file1);
                if (etag != null) {
                    FileUtils.writeStringToFile((File)file2, (String)etag, (String)"UTF-8");
                }
                FileUtils.writeStringToFile((File)file3, (String)Long.toString(t), (String)"UTF-8");
            }
            catch (IOException e) {
                if (file1.exists()) {
                    file1.delete();
                }
                if (file2.exists()) {
                    file2.delete();
                }
                if (file3.exists()) {
                    file3.delete();
                }
            }
        } else if (code == 404) {
            return Shared.dummy;
        }
        if (!file1.exists()) {
            return null;
        }
        return ImageIO.read(file1);
    }
}

