/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class MojangService {
    private static final LoadingCache<String, Optional<GameProfile>> cachedProfiles = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Optional<GameProfile>>(){
        Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<GameProfile> load(String key) throws Exception {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + key);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(Minecraft.func_71410_x().func_110437_J());
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            conn.setUseCaches(false);
            InputStream in = null;
            try {
                in = conn.getInputStream();
            }
            catch (IOException e) {
                IOUtils.closeQuietly((InputStream)in);
                in = conn.getErrorStream();
            }
            try {
                GameProfile parsed;
                if (in != null && (parsed = (GameProfile)this.gson.fromJson(IOUtils.toString((InputStream)in, (Charset)Charsets.UTF_8), GameProfile.class)) != null && parsed.getId() != null) {
                    Optional optional = Optional.of((Object)Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(new GameProfile(parsed.getId(), parsed.getName()), false));
                    return optional;
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            return Optional.absent();
        }
    });
    private static final GameProfile DUMMY = new GameProfile(UUID.fromString("fed3a6ca-d7de-11e5-b5d2-0a1d41d68578"), "[Dummy]");

    public static GameProfile getProfile(String username) {
        return MojangService.getProfile(username, DUMMY);
    }

    public static GameProfile getProfile(String username, GameProfile defaultValue) {
        try {
            return (GameProfile)((Optional)cachedProfiles.get((Object)username)).or((Object)defaultValue);
        }
        catch (ExecutionException ignored) {
            return defaultValue;
        }
    }
}

