/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.network;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import oreexcavation.client.ExcavationKeys;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.handlers.EventHandler;
import oreexcavation.handlers.MiningScheduler;
import oreexcavation.network.PacketExcavation;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.shapes.ShapeRegistry;
import org.apache.logging.log4j.Level;

public class ExcPacketHandler
implements BiConsumer<PacketExcavation, Supplier<NetworkEvent.Context>> {
    public static ExcPacketHandler INSTANCE = new ExcPacketHandler();

    @Override
    public void accept(PacketExcavation packet, Supplier<NetworkEvent.Context> context) {
        switch (context.get().getDirection().getOriginationSide()) {
            case CLIENT: {
                this.acceptServer(packet, context);
                context.get().setPacketHandled(true);
                break;
            }
            case SERVER: {
                this.acceptClient(packet, context);
                context.get().setPacketHandled(true);
            }
        }
    }

    private void acceptServer(PacketExcavation message, Supplier<NetworkEvent.Context> context) {
        Direction facing;
        ExcavateShape shape;
        ServerPlayerEntity player = context.get().getSender();
        if (player == null || player.func_184102_h() == null) {
            return;
        }
        if (message.getTags().func_74767_n("cancel")) {
            player.func_184102_h().func_213165_a(() -> MiningScheduler.INSTANCE.stopMining(player));
            return;
        }
        int x = message.getTags().func_74762_e("x");
        int y = message.getTags().func_74762_e("y");
        int z = message.getTags().func_74762_e("z");
        BlockState state = Block.func_196257_b((int)message.getTags().func_74762_e("stateId"));
        if (state.func_177230_c() == Blocks.field_150350_a) {
            OreExcavation.logger.log(Level.INFO, "Recieved invalid block ID");
        }
        if (message.getTags().func_74764_b("shape")) {
            if (!ExcavationSettings.allowShapes) {
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Shape mining has been disabled"), false);
                return;
            }
            shape = new ExcavateShape();
            shape.setMask(message.getTags().func_74762_e("shape"));
            if (message.getTags().func_74764_b("depth")) {
                shape.setMaxDepth(message.getTags().func_74762_e("depth"));
            }
            if (message.getTags().func_74764_b("origin")) {
                int origin = message.getTags().func_74762_e("origin");
                shape.setReticle(origin % 5, origin / 5);
            }
            facing = Direction.func_82600_a((int)message.getTags().func_74762_e("side"));
        } else {
            shape = null;
            facing = Direction.NORTH;
        }
        player.func_184102_h().func_213165_a(() -> MiningScheduler.INSTANCE.startMining(player, new BlockPos(x, y, z), state, shape, facing));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void acceptClient(PacketExcavation message, Supplier<NetworkEvent.Context> context) {
        if (ExcavationSettings.mineMode < 0) {
            return;
        }
        if (ExcavationSettings.mineMode == 0 ? ExcavationKeys.excavateKey.getKey().func_197937_c() == 0 || !ExcavationKeys.excavateKey.func_151470_d() : ExcavationSettings.mineMode != 2 && !Minecraft.func_71410_x().field_71439_g.func_225608_bj_()) {
            return;
        }
        EventHandler.isExcavating = true;
        ExcavateShape shape = ShapeRegistry.INSTANCE.getActiveShape();
        if (shape != null) {
            message.getTags().func_74768_a("shape", shape.getShapeMask());
            message.getTags().func_74768_a("depth", shape.getMaxDepth());
            message.getTags().func_74768_a("origin", shape.getReticle());
            if (!ExcavationSettings.useSideHit) {
                message.getTags().func_74768_a("side", ExcavateShape.getFacing((PlayerEntity)Minecraft.func_71410_x().field_71439_g).func_176745_a());
            }
        }
        OreExcavation.instance.network.sendToServer((Object)new PacketExcavation(message.getTags()));
    }
}

