/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.groups.BlockBlacklist;
import oreexcavation.groups.BlockGroups;
import oreexcavation.groups.ItemBlacklist;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.shapes.ShapeRegistry;
import oreexcavation.utils.JsonHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final ForgeConfigSpec commonSpec;
    public static final ForgeConfigSpec clientSpec;
    public static final ConfigCommon COMMON;
    public static final ConfigClient CLIENT;

    private static ForgeConfigSpec.IntValue lazyInt(ForgeConfigSpec.Builder builder, String var, int def, int min, int max, String com) {
        builder.comment(com);
        builder.translation("oreexcavation.config." + var.replaceAll(" ", "_"));
        return builder.defineInRange(var, def, min, max);
    }

    private static ForgeConfigSpec.DoubleValue lazyDouble(ForgeConfigSpec.Builder builder, String var, double def, double min, double max, String com) {
        builder.comment(com);
        builder.translation("oreexcavation.config." + var.replaceAll(" ", "_"));
        return builder.defineInRange(var, def, min, max);
    }

    private static ForgeConfigSpec.BooleanValue lazyBool(ForgeConfigSpec.Builder builder, String var, boolean def, String com) {
        builder.comment(com);
        builder.translation("oreexcavation.config." + var.replaceAll(" ", "_"));
        return builder.define(var, def);
    }

    private static ForgeConfigSpec.ConfigValue<String> lazyString(ForgeConfigSpec.Builder builder, String var, String def, String com) {
        builder.comment(com);
        builder.translation("oreexcavation.config." + var.replaceAll(" ", "_"));
        return builder.define(var, (Object)def);
    }

    private static ForgeConfigSpec.ConfigValue<List<? extends String>> lazyList(ForgeConfigSpec.Builder builder, String var, List<String> def, String com) {
        builder.comment(com);
        builder.translation("oreexcavation.config." + var.replaceAll(" ", "_"));
        return builder.defineList(var, def, o -> o instanceof String);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        if ("oreexcavation".equalsIgnoreCase(event.getConfig().getModId())) {
            if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
                ConfigHandler.CLIENT.apply();
            } else if (event.getConfig().getType() == ModConfig.Type.COMMON) {
                ConfigHandler.COMMON.apply();
                ConfigHandler.loadJsonFiles();
            }
        }
    }

    @SubscribeEvent
    public static void onFileChanged(ModConfig.ModConfigEvent event) {
        if ("oreexcavation".equalsIgnoreCase(event.getConfig().getModId())) {
            if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
                ConfigHandler.CLIENT.apply();
            } else if (event.getConfig().getType() == ModConfig.Type.COMMON) {
                ConfigHandler.COMMON.apply();
                ConfigHandler.loadJsonFiles();
            }
        }
    }

    private static void loadJsonFiles() {
        File fileOverrides = new File("config/oreexcavation_overrides.json");
        if (fileOverrides.exists()) {
            ToolOverrideHandler.INSTANCE.loadOverrides(JsonHelper.ReadFromFile(fileOverrides));
        } else {
            JsonObject json = ToolOverrideHandler.INSTANCE.getDefaultOverrides();
            JsonHelper.WriteToFile(fileOverrides, json);
            ToolOverrideHandler.INSTANCE.loadOverrides(json);
        }
        ShapeRegistry.INSTANCE.loadShapes(new File("config/oreexcavation_shapes.json"));
        File fileGroups = new File("config/oreexcavation_groups.json");
        if (fileGroups.exists()) {
            BlockGroups.INSTANCE.readFromJson(JsonHelper.ReadFromFile(fileGroups));
        } else {
            JsonObject json = BlockGroups.INSTANCE.getDefaultJson();
            JsonHelper.WriteToFile(fileGroups, json);
            BlockGroups.INSTANCE.readFromJson(json);
        }
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(x$0 -> new ConfigClient((ForgeConfigSpec.Builder)x$0));
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (ConfigClient)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(x$0 -> new ConfigCommon((ForgeConfigSpec.Builder)x$0));
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (ConfigCommon)commonSpecPair.getLeft();
    }

    public static class ConfigClient {
        public final ForgeConfigSpec.IntValue mineMode;
        public final ForgeConfigSpec.BooleanValue mustHold;
        public final ForgeConfigSpec.BooleanValue useSideHit;

        private ConfigClient(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            this.mineMode = ConfigHandler.lazyInt(builder, "Mode", 0, -1, 2, "Excavation mode (-1 Disabled, 0 = Keybind, 1 = Sneak, 2 = Always)");
            this.mustHold = ConfigHandler.lazyBool(builder, "Must Hold", true, "Allows players to cancel excavation by releasing the keys");
            this.useSideHit = ConfigHandler.lazyBool(builder, "Use Side Hit", true, "Use the side of the block hit to determine shape mining direction");
            builder.pop();
        }

        private void apply() {
            ExcavationSettings.mineMode = (Integer)this.mineMode.get();
            ExcavationSettings.mustHold = (Boolean)this.mustHold.get();
            ExcavationSettings.useSideHit = (Boolean)this.useSideHit.get();
        }
    }

    public static class ConfigCommon {
        public final ForgeConfigSpec.IntValue mineSpeed;
        public final ForgeConfigSpec.IntValue mineLimit;
        public final ForgeConfigSpec.IntValue mineRange;
        public final ForgeConfigSpec.DoubleValue exaustion;
        public final ForgeConfigSpec.IntValue experience;
        public final ForgeConfigSpec.IntValue maxUndos;
        public final ForgeConfigSpec.BooleanValue invertTBlacklist;
        public final ForgeConfigSpec.BooleanValue invertBBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> toolBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockBlacklist;
        public final ForgeConfigSpec.BooleanValue openHand;
        public final ForgeConfigSpec.BooleanValue ignoreTools;
        public final ForgeConfigSpec.BooleanValue toolClass;
        public final ForgeConfigSpec.BooleanValue altTools;
        public final ForgeConfigSpec.BooleanValue tpsGuard;
        public final ForgeConfigSpec.BooleanValue autoPickup;
        public final ForgeConfigSpec.BooleanValue allowShapes;
        public final ForgeConfigSpec.ConfigValue<String> gamestage;

        private ConfigCommon(ForgeConfigSpec.Builder builder) {
            builder.comment("Common settings").push("common");
            this.mineLimit = ConfigHandler.lazyInt(builder, "Limit", 128, 1, Integer.MAX_VALUE, "The maximum number of blocks that can be excavated at once");
            this.mineSpeed = ConfigHandler.lazyInt(builder, "Speed", 64, 1, Integer.MAX_VALUE, "How many blocks per tick can be excavated");
            this.mineRange = ConfigHandler.lazyInt(builder, "Range", 16, 1, Integer.MAX_VALUE, "How far from the origin an excavation can travel");
            this.exaustion = ConfigHandler.lazyDouble(builder, "Exaustion", 0.1, 0.0, Double.MAX_VALUE, "Amount of exaustion per block excavated");
            this.experience = ConfigHandler.lazyInt(builder, "Experience", 0, 0, Integer.MAX_VALUE, "Experience cost per block excavated");
            this.openHand = ConfigHandler.lazyBool(builder, "Open Hand", true, "Allow excavation with an open hand");
            this.invertTBlacklist = ConfigHandler.lazyBool(builder, "Invert Tool Blacklist", false, "Inverts the tool blacklist to function as a whitelist");
            this.invertBBlacklist = ConfigHandler.lazyBool(builder, "Invert Block Blacklist", false, "Inverts the block blacklist to function as a whitelist");
            this.ignoreTools = ConfigHandler.lazyBool(builder, "Ignore Tool", false, "Ignores whether or not the held tool is valid");
            this.altTools = ConfigHandler.lazyBool(builder, "Alt Tools", false, "Use alternate check for tool validity (e.g. swords on webs)");
            this.toolClass = ConfigHandler.lazyBool(builder, "Only Standard Types", false, "Limit excavation to standard tool types (Picks, Shoves, Axes & Shears)");
            this.tpsGuard = ConfigHandler.lazyBool(builder, "TPS Guard", true, "Temporarily reduces excavation speed if TPS begins to slow down");
            this.autoPickup = ConfigHandler.lazyBool(builder, "Auto Pickup", false, "Skips spawning drops in world adding them directly to your inventory");
            this.allowShapes = ConfigHandler.lazyBool(builder, "Allow Shapes", true, "Allow players to use shape mining");
            this.maxUndos = ConfigHandler.lazyInt(builder, "Max Undos", 3, 0, Integer.MAX_VALUE, "How many excavations should be kept in undo history (may lead to exploits or instability)");
            this.gamestage = ConfigHandler.lazyString(builder, "Game Stage", "", "The default game stage required to unlock excavations (requires gamestages to be installed)");
            this.toolBlacklist = ConfigHandler.lazyList(builder, "Tool Blacklist", Collections.emptyList(), "Tools blacklisted from excavating");
            this.blockBlacklist = ConfigHandler.lazyList(builder, "Block Blacklist", Collections.emptyList(), "Blocks blacklisted from being excavated");
            builder.pop();
        }

        private void apply() {
            ExcavationSettings.mineLimit = (Integer)this.mineLimit.get();
            ExcavationSettings.mineSpeed = (Integer)this.mineSpeed.get();
            ExcavationSettings.mineRange = (Integer)this.mineRange.get();
            ExcavationSettings.exaustion = ((Double)this.exaustion.get()).floatValue();
            ExcavationSettings.experience = (Integer)this.experience.get();
            ExcavationSettings.openHand = (Boolean)this.openHand.get();
            ExcavationSettings.invertTBlacklist = (Boolean)this.invertTBlacklist.get();
            ExcavationSettings.invertBBlacklist = (Boolean)this.invertBBlacklist.get();
            ExcavationSettings.ignoreTools = (Boolean)this.ignoreTools.get();
            ExcavationSettings.altTools = (Boolean)this.altTools.get();
            ExcavationSettings.toolClass = (Boolean)this.toolClass.get();
            ExcavationSettings.tpsGuard = (Boolean)this.tpsGuard.get();
            ExcavationSettings.autoPickup = (Boolean)this.autoPickup.get();
            ExcavationSettings.allowShapes = (Boolean)this.allowShapes.get();
            ExcavationSettings.maxUndos = (Integer)this.maxUndos.get();
            ExcavationSettings.gamestage = (String)this.gamestage.get();
            BlockBlacklist.INSTANCE.loadList(((List)this.blockBlacklist.get()).toArray(new String[0]));
            ItemBlacklist.INSTANCE.loadList(((List)this.toolBlacklist.get()).toArray(new String[0]));
        }
    }
}

