/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.groups;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import oreexcavation.core.OreExcavation;
import org.apache.logging.log4j.Level;

public class ItemEntry {
    public final ResourceLocation idName;
    public final String oreDict;
    public final int subType;

    public ItemEntry(ResourceLocation idName, int subType) {
        this.idName = idName;
        this.subType = subType;
        this.oreDict = null;
    }

    public ItemEntry(String oreDict) {
        this.oreDict = oreDict;
        this.idName = null;
        this.subType = -1;
    }

    public boolean checkMatch(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.idName == null) {
            return this.checkOre(stack);
        }
        ResourceLocation r = new ResourceLocation(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        return r.equals((Object)this.idName) && (this.subType < 0 || this.subType == Short.MAX_VALUE || this.subType == stack.func_77960_j());
    }

    private boolean checkOre(ItemStack stack) {
        if (this.oreDict == null) {
            return false;
        }
        if (this.oreDict.equals("*")) {
            return true;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).equals(this.oreDict)) continue;
            return true;
        }
        return false;
    }

    public static ItemEntry readFromString(String s) {
        int meta;
        if (s == null || s.length() <= 0) {
            return null;
        }
        String[] split = s.split(":");
        if (split.length <= 0 || split.length > 3) {
            return null;
        }
        if (split.length == 1) {
            return new ItemEntry(split[0]);
        }
        if (split.length == 2) {
            return new ItemEntry(new ResourceLocation(split[0], split[1]), -1);
        }
        try {
            meta = Integer.parseInt(split[2]);
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.ERROR, "Unable to read metadata value for Item Entry \"" + s + "\":", (Throwable)e);
            return null;
        }
        return new ItemEntry(new ResourceLocation(split[0], split[1]), meta);
    }
}

